/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.common.glossary.column;

import com.google.code.or.common.glossary.Column;

public final class TinyColumn
implements Column {
    private static final long serialVersionUID = 3629858638897033423L;
    public static final int MIN_VALUE = -128;
    public static final int MAX_VALUE = 127;
    private static final TinyColumn[] CACHE = new TinyColumn[256];
    private final int value;

    private TinyColumn(int value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public Integer getValue() {
        return this.value;
    }

    public static final TinyColumn valueOf(int value) {
        if (value < -128 || value > 127) {
            throw new IllegalArgumentException("invalid value: " + value);
        }
        return CACHE[value + 128];
    }

    static {
        for (int i = -128; i <= 127; ++i) {
            TinyColumn.CACHE[i + 128] = new TinyColumn(i);
        }
    }
}

