/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.common.util;

import com.google.code.or.common.util.ClassUtils;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XThreadFactory
implements ThreadFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(XThreadFactory.class);
    protected String name;
    protected final AtomicBoolean daemon;
    protected final AtomicBoolean trackThreads;
    protected final List<WeakReference<Thread>> threads;
    protected final ConcurrentHashMap<String, AtomicLong> sequences;
    protected final AtomicReference<Thread.UncaughtExceptionHandler> uncaughtExceptionHandler;

    public XThreadFactory() {
        this(null, false, null);
    }

    public XThreadFactory(String name) {
        this(name, false, null);
    }

    public XThreadFactory(String name, boolean daemon) {
        this(name, daemon, null);
    }

    public XThreadFactory(String name, boolean daemon, Thread.UncaughtExceptionHandler handler) {
        this.name = name;
        this.daemon = new AtomicBoolean(daemon);
        this.trackThreads = new AtomicBoolean(false);
        this.threads = new LinkedList<WeakReference<Thread>>();
        this.sequences = new ConcurrentHashMap();
        this.uncaughtExceptionHandler = new AtomicReference<Thread.UncaughtExceptionHandler>(handler);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDaemon() {
        return this.daemon.get();
    }

    public void setDaemon(boolean daemon) {
        this.daemon.set(daemon);
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler.get();
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.uncaughtExceptionHandler.set(handler);
    }

    public boolean isTrackThreads() {
        return this.trackThreads.get();
    }

    public void setTrackThreads(boolean trackThreads) {
        this.trackThreads.set(trackThreads);
    }

    public List<Thread> getAliveThreads() {
        return this.getThreads(true);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r);
        t.setDaemon(this.isDaemon());
        String prefix = this.name;
        if (prefix == null || prefix.equals("")) {
            prefix = this.getInvoker(2);
        }
        t.setName(prefix + "-" + this.getSequence(prefix));
        Thread.UncaughtExceptionHandler handler = this.getUncaughtExceptionHandler();
        if (handler != null) {
            t.setUncaughtExceptionHandler(handler);
        } else {
            t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                public void uncaughtException(Thread t, Throwable e) {
                    LOGGER.error("unhandled exception in thread: " + t.getId() + ":" + t.getName(), e);
                }
            });
        }
        if (this.isTrackThreads()) {
            this.addThread(t);
        }
        return t;
    }

    protected String getInvoker(int depth) {
        Exception e = new Exception();
        StackTraceElement[] stes = e.getStackTrace();
        if (stes.length > depth) {
            return ClassUtils.getShortClassName(stes[depth].getClassName());
        }
        return this.getClass().getSimpleName();
    }

    protected long getSequence(String invoker) {
        AtomicLong existing;
        AtomicLong r = this.sequences.get(invoker);
        if (r == null && (existing = this.sequences.putIfAbsent(invoker, r = new AtomicLong(0L))) != null) {
            r = existing;
        }
        return r.incrementAndGet();
    }

    protected synchronized void addThread(Thread thread) {
        Iterator<WeakReference<Thread>> iter = this.threads.iterator();
        while (iter.hasNext()) {
            Thread t = (Thread)iter.next().get();
            if (t != null) continue;
            iter.remove();
        }
        this.threads.add(new WeakReference<Thread>(thread));
    }

    protected synchronized List<Thread> getThreads(boolean aliveOnly) {
        LinkedList<Thread> r = new LinkedList<Thread>();
        Iterator<WeakReference<Thread>> iter = this.threads.iterator();
        while (iter.hasNext()) {
            Thread t = (Thread)iter.next().get();
            if (t == null) {
                iter.remove();
                continue;
            }
            if (aliveOnly && !t.isAlive()) continue;
            r.add(t);
        }
        return r;
    }
}

