/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.net.impl;

import com.google.code.or.binlog.impl.event.BinlogEventV4HeaderImpl;
import com.google.code.or.io.CRCException;
import com.google.code.or.io.XInputStream;
import com.google.code.or.io.impl.XInputStreamImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class EventInputStream
extends XInputStreamImpl
implements XInputStream {
    private final XInputStream dataStream;
    private boolean checksumEnabled = false;
    private CRC32 crc = null;

    public EventInputStream(XInputStream is) {
        super((InputStream)((Object)is));
        this.dataStream = is;
    }

    public BinlogEventV4HeaderImpl getNextBinlogHeader() throws IOException {
        BinlogEventV4HeaderImpl header = new BinlogEventV4HeaderImpl();
        this.setReadLimit(0);
        this.crc = this.isChecksumEnabled() ? new CRC32() : null;
        header.setTimestamp(this.readLong(4) * 1000L);
        header.setEventType(this.readInt(1));
        header.setServerId(this.readLong(4));
        header.setEventLength(this.readInt(4));
        long eventLimit = header.getEventLength() - 13L;
        if (this.isChecksumEnabled() && header.getEventType() != 15) {
            eventLimit -= 4L;
        }
        this.setReadLimit((int)eventLimit);
        header.setNextPosition(this.readLong(4));
        header.setFlags(this.readInt(2));
        header.setTimestampOfReceipt(System.currentTimeMillis());
        return header;
    }

    public boolean isChecksumEnabled() {
        return this.checksumEnabled;
    }

    public void setChecksumEnabled(boolean checksumEnabled) {
        this.checksumEnabled = checksumEnabled;
    }

    public void finishEvent(BinlogEventV4HeaderImpl header) throws IOException {
        if (this.available() != 0) {
            throw new RuntimeException("assertion failed!  We left " + this.available() + " unconsumed bytes in the buffer for event: " + header);
        }
        if (this.isChecksumEnabled() && header.getEventType() != 15) {
            long calculatedCRC = this.crc.getValue();
            this.setReadLimit(0);
            Long checksum = this.readLong(4);
            if (checksum != calculatedCRC) {
                throw new CRCException(header);
            }
        }
    }

    public long skip(long n) throws IOException {
        if (!this.isChecksumEnabled()) {
            this.readCount = (int)((long)this.readCount + n);
            return this.dataStream.skip(n);
        }
        byte[] b = new byte[(int)n];
        this.read(b, 0, (int)n);
        return n;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.readCount += len;
        int ret = this.dataStream.read(b, off, len);
        if (this.isChecksumEnabled() && this.crc != null) {
            this.crc.update(b, off, len);
        }
        return ret;
    }

    public int read() throws IOException {
        int b = this.dataStream.read();
        ++this.readCount;
        if (this.isChecksumEnabled() && this.crc != null) {
            this.crc.update(b);
        }
        return b;
    }
}

