/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.net.impl;

import com.google.code.or.common.glossary.column.StringColumn;
import com.google.code.or.net.Packet;
import com.google.code.or.net.Transport;
import com.google.code.or.net.TransportException;
import com.google.code.or.net.impl.packet.ErrorPacket;
import com.google.code.or.net.impl.packet.ResultSetHeaderPacket;
import com.google.code.or.net.impl.packet.ResultSetRowPacket;
import com.google.code.or.net.impl.packet.command.ComQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query {
    private static final Logger LOGGER = LoggerFactory.getLogger(Query.class);
    private final Transport transport;

    public Query(Transport transport) {
        this.transport = transport;
    }

    public List<String> getFirst(String sql) throws IOException, TransportException {
        ArrayList<String> result = null;
        ComQuery command = new ComQuery();
        command.setSql(StringColumn.valueOf(sql.getBytes()));
        this.transport.getOutputStream().writePacket(command);
        this.transport.getOutputStream().flush();
        Packet packet = this.transport.getInputStream().readPacket();
        if (packet.getPacketBody()[0] == -1) {
            throw new TransportException(ErrorPacket.valueOf(packet));
        }
        ResultSetHeaderPacket header = ResultSetHeaderPacket.valueOf(packet);
        if (header.getFieldCount().longValue() == 0L) {
            return null;
        }
        while ((packet = this.transport.getInputStream().readPacket()).getPacketBody()[0] != -2) {
        }
        while ((packet = this.transport.getInputStream().readPacket()).getPacketBody()[0] != -2) {
            ResultSetRowPacket row = ResultSetRowPacket.valueOf(packet);
            if (result != null) continue;
            result = new ArrayList<String>();
            for (StringColumn c : row.getColumns()) {
                result.add(c.toString());
            }
        }
        return result;
    }
}

