/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.net.impl.packet;

import com.google.code.or.common.util.ToStringBuilder;
import com.google.code.or.io.XInputStream;
import com.google.code.or.io.util.XDeserializer;
import com.google.code.or.io.util.XSerializer;
import com.google.code.or.net.Packet;
import com.google.code.or.net.impl.packet.AbstractPacket;
import java.io.IOException;

public class EOFPacket
extends AbstractPacket {
    private static final long serialVersionUID = 7001637720833705527L;
    public static final byte PACKET_MARKER = -2;
    private int packetMarker;
    private int warningCount;
    private int serverStatus;

    public String toString() {
        return new ToStringBuilder(this).append("packetMarker", this.packetMarker).append("warningCount", this.warningCount).append("serverStatus", this.serverStatus).toString();
    }

    public byte[] getPacketBody() {
        XSerializer s = new XSerializer(32);
        s.writeInt(this.packetMarker, 1);
        s.writeInt(this.warningCount, 2);
        s.writeInt(this.serverStatus, 2);
        return s.toByteArray();
    }

    public int getPacketMarker() {
        return this.packetMarker;
    }

    public void setPacketMarker(int packetMarker) {
        this.packetMarker = packetMarker;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void setWarningCount(int warningCount) {
        this.warningCount = warningCount;
    }

    public int getServerStatus() {
        return this.serverStatus;
    }

    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
    }

    public static EOFPacket valueOf(Packet packet) throws IOException {
        XDeserializer d = new XDeserializer(packet.getPacketBody());
        EOFPacket r = new EOFPacket();
        r.length = packet.getLength();
        r.sequence = packet.getSequence();
        r.packetMarker = d.readInt(1);
        r.warningCount = d.readInt(2);
        r.serverStatus = d.readInt(2);
        return r;
    }

    public static EOFPacket valueOf(int packetLength, int packetSequence, int packetMarker, XInputStream is) throws IOException {
        EOFPacket r = new EOFPacket();
        r.length = packetLength;
        r.sequence = packetSequence;
        r.packetMarker = packetMarker;
        r.warningCount = is.readInt(2);
        r.serverStatus = is.readInt(2);
        return r;
    }
}

