/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.net.impl.packet;

import com.google.code.or.common.glossary.column.StringColumn;
import com.google.code.or.common.util.ToStringBuilder;
import com.google.code.or.io.XInputStream;
import com.google.code.or.io.util.XDeserializer;
import com.google.code.or.io.util.XSerializer;
import com.google.code.or.net.Packet;
import com.google.code.or.net.impl.packet.AbstractPacket;
import java.io.IOException;

public class ErrorPacket
extends AbstractPacket {
    private static final long serialVersionUID = -6842057808734657288L;
    public static final byte PACKET_MARKER = -1;
    private int packetMarker;
    private int errorCode;
    private StringColumn slash;
    private StringColumn sqlState;
    private StringColumn errorMessage;

    public String toString() {
        return new ToStringBuilder(this).append("packetMarker", this.packetMarker).append("errorCode", this.errorCode).append("slash", this.slash).append("sqlState", this.sqlState).append("errorMessage", this.errorMessage).toString();
    }

    public byte[] getPacketBody() {
        XSerializer s = new XSerializer(64);
        s.writeInt(this.packetMarker, 1);
        s.writeInt(this.errorCode, 2);
        s.writeFixedLengthString(this.slash);
        s.writeFixedLengthString(this.sqlState);
        s.writeFixedLengthString(this.errorMessage);
        return s.toByteArray();
    }

    public int getPacketMarker() {
        return this.packetMarker;
    }

    public void setPacketMarker(int fieldCount) {
        this.packetMarker = fieldCount;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public StringColumn getSlash() {
        return this.slash;
    }

    public void setSlash(StringColumn slash) {
        this.slash = slash;
    }

    public StringColumn getSqlState() {
        return this.sqlState;
    }

    public void setSqlState(StringColumn sqlState) {
        this.sqlState = sqlState;
    }

    public StringColumn getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(StringColumn errorMessage) {
        this.errorMessage = errorMessage;
    }

    public static ErrorPacket valueOf(Packet packet) throws IOException {
        XDeserializer d = new XDeserializer(packet.getPacketBody());
        ErrorPacket r = new ErrorPacket();
        r.length = packet.getLength();
        r.sequence = packet.getSequence();
        r.packetMarker = d.readInt(1);
        r.errorCode = d.readInt(2);
        r.slash = d.readFixedLengthString(1);
        r.sqlState = d.readFixedLengthString(5);
        r.errorMessage = d.readFixedLengthString(d.available());
        return r;
    }

    public static ErrorPacket valueOf(int packetLength, int packetSequence, int packetMarker, XInputStream is) throws IOException {
        ErrorPacket r = new ErrorPacket();
        r.length = packetLength;
        r.sequence = packetSequence;
        r.packetMarker = packetMarker;
        r.errorCode = is.readInt(2);
        r.slash = is.readFixedLengthString(1);
        r.sqlState = is.readFixedLengthString(5);
        r.errorMessage = is.readFixedLengthString(is.available());
        return r;
    }
}

