/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Customizable app settings.")
@JsonPropertyOrder(value={"conversationRetentionSeconds", "maskCreditCardNumbers", "useAnimalNames", "echoPostback", "ignoreAutoConversationStart", "multiConvoEnabled", "attachmentsAccess", "attachmentsTokenExpirationSeconds", "appLocalizationEnabled"})
public class AppSettings {
    public static final String JSON_PROPERTY_CONVERSATION_RETENTION_SECONDS = "conversationRetentionSeconds";
    private Integer conversationRetentionSeconds;
    public static final String JSON_PROPERTY_MASK_CREDIT_CARD_NUMBERS = "maskCreditCardNumbers";
    private Boolean maskCreditCardNumbers;
    public static final String JSON_PROPERTY_USE_ANIMAL_NAMES = "useAnimalNames";
    private Boolean useAnimalNames;
    public static final String JSON_PROPERTY_ECHO_POSTBACK = "echoPostback";
    private Boolean echoPostback;
    public static final String JSON_PROPERTY_IGNORE_AUTO_CONVERSATION_START = "ignoreAutoConversationStart";
    private Boolean ignoreAutoConversationStart;
    public static final String JSON_PROPERTY_MULTI_CONVO_ENABLED = "multiConvoEnabled";
    private Boolean multiConvoEnabled;
    public static final String JSON_PROPERTY_ATTACHMENTS_ACCESS = "attachmentsAccess";
    private String attachmentsAccess;
    public static final String JSON_PROPERTY_ATTACHMENTS_TOKEN_EXPIRATION_SECONDS = "attachmentsTokenExpirationSeconds";
    private Integer attachmentsTokenExpirationSeconds;
    public static final String JSON_PROPERTY_APP_LOCALIZATION_ENABLED = "appLocalizationEnabled";
    private Boolean appLocalizationEnabled;

    public AppSettings conversationRetentionSeconds(Integer conversationRetentionSeconds) {
        this.conversationRetentionSeconds = conversationRetentionSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of seconds of inactivity before a conversation\u2019s messages  will be automatically deleted. See  [Conversation Retention Seconds](https://docs.smooch.io/guide/creating-and-managing-apps/#conversation-retention-seconds) for more information. ")
    @JsonProperty(value="conversationRetentionSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getConversationRetentionSeconds() {
        return this.conversationRetentionSeconds;
    }

    public void setConversationRetentionSeconds(Integer conversationRetentionSeconds) {
        this.conversationRetentionSeconds = conversationRetentionSeconds;
    }

    public AppSettings maskCreditCardNumbers(Boolean maskCreditCardNumbers) {
        this.maskCreditCardNumbers = maskCreditCardNumbers;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A boolean specifying whether credit card numbers should be masked  when sent through Sunshine Conversations. ")
    @JsonProperty(value="maskCreditCardNumbers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMaskCreditCardNumbers() {
        return this.maskCreditCardNumbers;
    }

    public void setMaskCreditCardNumbers(Boolean maskCreditCardNumbers) {
        this.maskCreditCardNumbers = maskCreditCardNumbers;
    }

    public AppSettings useAnimalNames(Boolean useAnimalNames) {
        this.useAnimalNames = useAnimalNames;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A boolean specifying whether animal names should be used for  unnamed users. See the  [user naming guide](https://docs.smooch.io/guide/receiving-messages/#message-author-name) for details. ")
    @JsonProperty(value="useAnimalNames")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUseAnimalNames() {
        return this.useAnimalNames;
    }

    public void setUseAnimalNames(Boolean useAnimalNames) {
        this.useAnimalNames = useAnimalNames;
    }

    public AppSettings echoPostback(Boolean echoPostback) {
        this.echoPostback = echoPostback;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A boolean specifying whether a message should be added to the conversation  history when a postback button is clicked. See  [Echo Postbacks](https://docs.smooch.io/guide/creating-and-managing-apps/#echo-postbacks) for more information. ")
    @JsonProperty(value="echoPostback")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEchoPostback() {
        return this.echoPostback;
    }

    public void setEchoPostback(Boolean echoPostback) {
        this.echoPostback = echoPostback;
    }

    public AppSettings ignoreAutoConversationStart(Boolean ignoreAutoConversationStart) {
        this.ignoreAutoConversationStart = ignoreAutoConversationStart;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A boolean specifying whether a non message event coming from a channel will  trigger a  [start conversation](https://docs.smooch.io/rest/#section/Webhook-Triggers) event and count as a monthly active user (MAU). <aside class=\"notice\">Calling <code>startConversation()</code> (or equivalent) from the Android,  iOS or Web SDK will count as a MAU, regardless of the value of this setting.</aside> ")
    @JsonProperty(value="ignoreAutoConversationStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIgnoreAutoConversationStart() {
        return this.ignoreAutoConversationStart;
    }

    public void setIgnoreAutoConversationStart(Boolean ignoreAutoConversationStart) {
        this.ignoreAutoConversationStart = ignoreAutoConversationStart;
    }

    public AppSettings multiConvoEnabled(Boolean multiConvoEnabled) {
        this.multiConvoEnabled = multiConvoEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A boolean specifying whether users are allowed to be part of several conversations. Enabling `multiConvo` is **irreversible**. ")
    @JsonProperty(value="multiConvoEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMultiConvoEnabled() {
        return this.multiConvoEnabled;
    }

    public void setMultiConvoEnabled(Boolean multiConvoEnabled) {
        this.multiConvoEnabled = multiConvoEnabled;
    }

    public AppSettings attachmentsAccess(String attachmentsAccess) {
        this.attachmentsAccess = attachmentsAccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="public", value="A string specifying whether attachments should be stored in a publicly or privately accessible cloud storage. attachmentsAccess is set to public by default but can be modified to private. See <a href=\"https://docs.smooch.io/guide/private-attachments/\">Private Attachments</a> for more information. ")
    @JsonProperty(value="attachmentsAccess")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAttachmentsAccess() {
        return this.attachmentsAccess;
    }

    public void setAttachmentsAccess(String attachmentsAccess) {
        this.attachmentsAccess = attachmentsAccess;
    }

    public AppSettings attachmentsTokenExpirationSeconds(Integer attachmentsTokenExpirationSeconds) {
        this.attachmentsTokenExpirationSeconds = attachmentsTokenExpirationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="64028", value="Number of seconds representing the expiration time of the generated media tokens for private attachments. The JWT will be valid for 2 hours by default. See See <a href=\"https://docs.smooch.io/guide/private-attachments/\">Private Attachments</a> for more information. ")
    @JsonProperty(value="attachmentsTokenExpirationSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAttachmentsTokenExpirationSeconds() {
        return this.attachmentsTokenExpirationSeconds;
    }

    public void setAttachmentsTokenExpirationSeconds(Integer attachmentsTokenExpirationSeconds) {
        this.attachmentsTokenExpirationSeconds = attachmentsTokenExpirationSeconds;
    }

    public AppSettings appLocalizationEnabled(Boolean appLocalizationEnabled) {
        this.appLocalizationEnabled = appLocalizationEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A boolean specifying whether the messages authored by the Sunshine Conversations platform should be localized. ")
    @JsonProperty(value="appLocalizationEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAppLocalizationEnabled() {
        return this.appLocalizationEnabled;
    }

    public void setAppLocalizationEnabled(Boolean appLocalizationEnabled) {
        this.appLocalizationEnabled = appLocalizationEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppSettings appSettings = (AppSettings)o;
        return Objects.equals(this.conversationRetentionSeconds, appSettings.conversationRetentionSeconds) && Objects.equals(this.maskCreditCardNumbers, appSettings.maskCreditCardNumbers) && Objects.equals(this.useAnimalNames, appSettings.useAnimalNames) && Objects.equals(this.echoPostback, appSettings.echoPostback) && Objects.equals(this.ignoreAutoConversationStart, appSettings.ignoreAutoConversationStart) && Objects.equals(this.multiConvoEnabled, appSettings.multiConvoEnabled) && Objects.equals(this.attachmentsAccess, appSettings.attachmentsAccess) && Objects.equals(this.attachmentsTokenExpirationSeconds, appSettings.attachmentsTokenExpirationSeconds) && Objects.equals(this.appLocalizationEnabled, appSettings.appLocalizationEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.conversationRetentionSeconds, this.maskCreditCardNumbers, this.useAnimalNames, this.echoPostback, this.ignoreAutoConversationStart, this.multiConvoEnabled, this.attachmentsAccess, this.attachmentsTokenExpirationSeconds, this.appLocalizationEnabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppSettings {\n");
        sb.append("    conversationRetentionSeconds: ").append(this.toIndentedString(this.conversationRetentionSeconds)).append("\n");
        sb.append("    maskCreditCardNumbers: ").append(this.toIndentedString(this.maskCreditCardNumbers)).append("\n");
        sb.append("    useAnimalNames: ").append(this.toIndentedString(this.useAnimalNames)).append("\n");
        sb.append("    echoPostback: ").append(this.toIndentedString(this.echoPostback)).append("\n");
        sb.append("    ignoreAutoConversationStart: ").append(this.toIndentedString(this.ignoreAutoConversationStart)).append("\n");
        sb.append("    multiConvoEnabled: ").append(this.toIndentedString(this.multiConvoEnabled)).append("\n");
        sb.append("    attachmentsAccess: ").append(this.toIndentedString(this.attachmentsAccess)).append("\n");
        sb.append("    attachmentsTokenExpirationSeconds: ").append(this.toIndentedString(this.attachmentsTokenExpirationSeconds)).append("\n");
        sb.append("    appLocalizationEnabled: ").append(this.toIndentedString(this.appLocalizationEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

