/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A connected user identity, such as an email.")
@JsonPropertyOrder(value={"type", "value", "verification"})
public class Identity {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;
    public static final String JSON_PROPERTY_VERIFICATION = "verification";
    private String verification;

    public Identity type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="email", value="The type of identity.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Identity value(String value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="jane.doe@gmail.com", value="The identity value.")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Identity verification(String verification) {
        this.verification = verification;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="embed", value="The type of verification performed on the identity.")
    @JsonProperty(value="verification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVerification() {
        return this.verification;
    }

    public void setVerification(String verification) {
        this.verification = verification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identity identity = (Identity)o;
        return Objects.equals(this.type, identity.type) && Objects.equals(this.value, identity.value) && Objects.equals(this.verification, identity.verification);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.value, this.verification);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Identity {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    verification: ").append(this.toIndentedString(this.verification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

