/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "channelId", "channelSecret", "channelAccessToken", "serviceCode", "switcherSecret", "qrCodeUrl", "lineId"})
public class LineAllOf {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "line";
    public static final String JSON_PROPERTY_CHANNEL_ID = "channelId";
    private String channelId;
    public static final String JSON_PROPERTY_CHANNEL_SECRET = "channelSecret";
    private String channelSecret;
    public static final String JSON_PROPERTY_CHANNEL_ACCESS_TOKEN = "channelAccessToken";
    private String channelAccessToken;
    public static final String JSON_PROPERTY_SERVICE_CODE = "serviceCode";
    private String serviceCode;
    public static final String JSON_PROPERTY_SWITCHER_SECRET = "switcherSecret";
    private String switcherSecret;
    public static final String JSON_PROPERTY_QR_CODE_URL = "qrCodeUrl";
    private String qrCodeUrl;
    public static final String JSON_PROPERTY_LINE_ID = "lineId";
    private String lineId;

    public LineAllOf type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For LINE, each of your customers will need to manually configure a webhook in their LINE configuration page that will point to Sunshine Conversations servers. You must instruct your customers how to configure this manually on their LINE bot page. Once you\u2019ve acquired all the required information, call the Create Integration endpoint. Then, using the returned integration _id, your customer must set the Callback URL field in their LINE Business Center page. The URL should look like the following: `https://app.smooch.io:443/api/line/webhooks/{appId}/{integrationId}`. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public LineAllOf channelId(String channelId) {
        this.channelId = channelId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1286564967", value="LINE Channel ID. Can be omitted along with `channelSecret` to integrate LINE to setup a webhook before receiving the `channelId` and `channelSecret` back from LINE.")
    @JsonProperty(value="channelId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public LineAllOf channelSecret(String channelSecret) {
        this.channelSecret = channelSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_line_channel_secret", value="LINE Channel Secret. Can be omitted along with `channelId` to integrate LINE to setup a webhook before receiving the `channelId` and `channelSecret` back from LINE.")
    @JsonProperty(value="channelSecret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getChannelSecret() {
        return this.channelSecret;
    }

    public void setChannelSecret(String channelSecret) {
        this.channelSecret = channelSecret;
    }

    public LineAllOf channelAccessToken(String channelAccessToken) {
        this.channelAccessToken = channelAccessToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_line_channel_token", value="LINE Channel Access Token.")
    @JsonProperty(value="channelAccessToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getChannelAccessToken() {
        return this.channelAccessToken;
    }

    public void setChannelAccessToken(String channelAccessToken) {
        this.channelAccessToken = channelAccessToken;
    }

    public LineAllOf serviceCode(String serviceCode) {
        this.serviceCode = serviceCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_line_service_code", value="LINE Service Code.")
    @JsonProperty(value="serviceCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getServiceCode() {
        return this.serviceCode;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public LineAllOf switcherSecret(String switcherSecret) {
        this.switcherSecret = switcherSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_line_switcher_secret", value="LINE Switcher Secret.")
    @JsonProperty(value="switcherSecret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSwitcherSecret() {
        return this.switcherSecret;
    }

    public void setSwitcherSecret(String switcherSecret) {
        this.switcherSecret = switcherSecret;
    }

    public LineAllOf qrCodeUrl(String qrCodeUrl) {
        this.qrCodeUrl = qrCodeUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://qr-official.line.me/M/1O4fb8.png", value="URL provided by LINE in the [Developer Console](https://developers.line.biz/console/).")
    @JsonProperty(value="qrCodeUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQrCodeUrl() {
        return this.qrCodeUrl;
    }

    public void setQrCodeUrl(String qrCodeUrl) {
        this.qrCodeUrl = qrCodeUrl;
    }

    @Nullable
    @ApiModelProperty(example="104fb8", value="LINE Basic ID. Is automatically set when qrCodeUrl is updated.")
    @JsonProperty(value="lineId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLineId() {
        return this.lineId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineAllOf lineAllOf = (LineAllOf)o;
        return Objects.equals(this.type, lineAllOf.type) && Objects.equals(this.channelId, lineAllOf.channelId) && Objects.equals(this.channelSecret, lineAllOf.channelSecret) && Objects.equals(this.channelAccessToken, lineAllOf.channelAccessToken) && Objects.equals(this.serviceCode, lineAllOf.serviceCode) && Objects.equals(this.switcherSecret, lineAllOf.switcherSecret) && Objects.equals(this.qrCodeUrl, lineAllOf.qrCodeUrl) && Objects.equals(this.lineId, lineAllOf.lineId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.channelId, this.channelSecret, this.channelAccessToken, this.serviceCode, this.switcherSecret, this.qrCodeUrl, this.lineId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LineAllOf {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    channelId: ").append(this.toIndentedString(this.channelId)).append("\n");
        sb.append("    channelSecret: ").append(this.toIndentedString(this.channelSecret)).append("\n");
        sb.append("    channelAccessToken: ").append(this.toIndentedString(this.channelAccessToken)).append("\n");
        sb.append("    serviceCode: ").append(this.toIndentedString(this.serviceCode)).append("\n");
        sb.append("    switcherSecret: ").append(this.toIndentedString(this.switcherSecret)).append("\n");
        sb.append("    qrCodeUrl: ").append(this.toIndentedString(this.qrCodeUrl)).append("\n");
        sb.append("    lineId: ").append(this.toIndentedString(this.lineId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

