/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "name", "integrationId", "integrationType"})
public class SwitchboardIntegrationWebhook {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_INTEGRATION_ID = "integrationId";
    private String integrationId;
    public static final String JSON_PROPERTY_INTEGRATION_TYPE = "integrationType";
    private String integrationType;

    public SwitchboardIntegrationWebhook id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5ef21b86e933b7355c11c604", value="The unique ID of the switchboard integration.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SwitchboardIntegrationWebhook name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="bot", value="Identifier for use in control transfer protocols. Restricted to alphanumeric characters, `-` and `_`.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SwitchboardIntegrationWebhook integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5ef21b86e933b7355c11c605", value="Id of the integration that should deliver events routed by the switchboard.")
    @JsonProperty(value="integrationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public SwitchboardIntegrationWebhook integrationType(String integrationType) {
        this.integrationType = integrationType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="zd:agentWorkspace", value="Type of integration that should deliver events routed by the switchboard. If referencing an OAuth integration, the clientId issued by Sunshine Conversations during the OAuth partnership process will be the value of integrationType.")
    @JsonProperty(value="integrationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIntegrationType() {
        return this.integrationType;
    }

    public void setIntegrationType(String integrationType) {
        this.integrationType = integrationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwitchboardIntegrationWebhook switchboardIntegrationWebhook = (SwitchboardIntegrationWebhook)o;
        return Objects.equals(this.id, switchboardIntegrationWebhook.id) && Objects.equals(this.name, switchboardIntegrationWebhook.name) && Objects.equals(this.integrationId, switchboardIntegrationWebhook.integrationId) && Objects.equals(this.integrationType, switchboardIntegrationWebhook.integrationType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.integrationId, this.integrationType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SwitchboardIntegrationWebhook {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    integrationType: ").append(this.toIndentedString(this.integrationType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

