/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"enabled", "defaultSwitchboardIntegrationId"})
public class SwitchboardUpdateBody {
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_DEFAULT_SWITCHBOARD_INTEGRATION_ID = "defaultSwitchboardIntegrationId";
    private String defaultSwitchboardIntegrationId;

    public SwitchboardUpdateBody enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the switchboard is enabled. Allows creating the switchboard in a disabled state so that messages don't get lost or misrouted during switchboard configuration. When a switchboard is disabled, integrations linked to the switchboard will receive all events.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public SwitchboardUpdateBody defaultSwitchboardIntegrationId(String defaultSwitchboardIntegrationId) {
        this.defaultSwitchboardIntegrationId = defaultSwitchboardIntegrationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5ef21b132f21af34f088530e", value="The id of the switchboard integration that will be given control when a new conversation begins. It will also be used for conversations that existed before the switchboard was enabled.")
    @JsonProperty(value="defaultSwitchboardIntegrationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultSwitchboardIntegrationId() {
        return this.defaultSwitchboardIntegrationId;
    }

    public void setDefaultSwitchboardIntegrationId(String defaultSwitchboardIntegrationId) {
        this.defaultSwitchboardIntegrationId = defaultSwitchboardIntegrationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwitchboardUpdateBody switchboardUpdateBody = (SwitchboardUpdateBody)o;
        return Objects.equals(this.enabled, switchboardUpdateBody.enabled) && Objects.equals(this.defaultSwitchboardIntegrationId, switchboardUpdateBody.defaultSwitchboardIntegrationId);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.defaultSwitchboardIntegrationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SwitchboardUpdateBody {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    defaultSwitchboardIntegrationId: ").append(this.toIndentedString(this.defaultSwitchboardIntegrationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

