/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"isDefault", "displayName", "description", "iconUrl", "businessLastRead", "lastUpdatedAt"})
public class ConversationAllOf {
    public static final String JSON_PROPERTY_IS_DEFAULT = "isDefault";
    private Boolean isDefault;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName = null;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private JsonNullable<String> description = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ICON_URL = "iconUrl";
    private JsonNullable<URI> iconUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_BUSINESS_LAST_READ = "businessLastRead";
    private JsonNullable<String> businessLastRead = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LAST_UPDATED_AT = "lastUpdatedAt";
    private JsonNullable<String> lastUpdatedAt = JsonNullable.undefined();

    public ConversationAllOf isDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether the conversation is the default conversation for the user. Will be true for the first personal conversation created for the user, and false in all other cases. ")
    @JsonProperty(value="isDefault")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public ConversationAllOf displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My conversation", value="A friendly name for the conversation, may be displayed to the business or the user. ")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ConversationAllOf description(String description) {
        this.description = JsonNullable.of((Object)description);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Conversation between Rogers and Carl.", value="A short text describing the conversation.")
    @JsonIgnore
    public String getDescription() {
        return (String)this.description.orElse(null);
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDescription_JsonNullable() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription_JsonNullable(JsonNullable<String> description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = JsonNullable.of((Object)description);
    }

    public ConversationAllOf iconUrl(URI iconUrl) {
        this.iconUrl = JsonNullable.of((Object)iconUrl);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://www.gravatar.com/image.jpg", value="A custom conversation icon url. The image must be in either JPG, PNG, or GIF format")
    @JsonIgnore
    public URI getIconUrl() {
        return (URI)this.iconUrl.orElse(null);
    }

    @JsonProperty(value="iconUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<URI> getIconUrl_JsonNullable() {
        return this.iconUrl;
    }

    @JsonProperty(value="iconUrl")
    public void setIconUrl_JsonNullable(JsonNullable<URI> iconUrl) {
        this.iconUrl = iconUrl;
    }

    public void setIconUrl(URI iconUrl) {
        this.iconUrl = JsonNullable.of((Object)iconUrl);
    }

    public ConversationAllOf businessLastRead(String businessLastRead) {
        this.businessLastRead = JsonNullable.of((Object)businessLastRead);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-06-23T14:33:47.492Z", value="A datetime string with the format YYYY-MM-DDThh:mm:ss.SSSZ representing the moment the conversation was last marked as read with role business. ")
    @JsonIgnore
    public String getBusinessLastRead() {
        return (String)this.businessLastRead.orElse(null);
    }

    @JsonProperty(value="businessLastRead")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getBusinessLastRead_JsonNullable() {
        return this.businessLastRead;
    }

    @JsonProperty(value="businessLastRead")
    public void setBusinessLastRead_JsonNullable(JsonNullable<String> businessLastRead) {
        this.businessLastRead = businessLastRead;
    }

    public void setBusinessLastRead(String businessLastRead) {
        this.businessLastRead = JsonNullable.of((Object)businessLastRead);
    }

    public ConversationAllOf lastUpdatedAt(String lastUpdatedAt) {
        this.lastUpdatedAt = JsonNullable.of((Object)lastUpdatedAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-06-26T14:33:47.120Z", value="A datetime string with the format YYYY-MM-DDThh:mm:ss.SSSZ representing the moment the last message was received in the conversation, or the creation time if no messages have been received yet. ")
    @JsonIgnore
    public String getLastUpdatedAt() {
        return (String)this.lastUpdatedAt.orElse(null);
    }

    @JsonProperty(value="lastUpdatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getLastUpdatedAt_JsonNullable() {
        return this.lastUpdatedAt;
    }

    @JsonProperty(value="lastUpdatedAt")
    public void setLastUpdatedAt_JsonNullable(JsonNullable<String> lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public void setLastUpdatedAt(String lastUpdatedAt) {
        this.lastUpdatedAt = JsonNullable.of((Object)lastUpdatedAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationAllOf conversationAllOf = (ConversationAllOf)o;
        return Objects.equals(this.isDefault, conversationAllOf.isDefault) && Objects.equals(this.displayName, conversationAllOf.displayName) && Objects.equals(this.description, conversationAllOf.description) && Objects.equals(this.iconUrl, conversationAllOf.iconUrl) && Objects.equals(this.businessLastRead, conversationAllOf.businessLastRead) && Objects.equals(this.lastUpdatedAt, conversationAllOf.lastUpdatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.isDefault, this.displayName, this.description, this.iconUrl, this.businessLastRead, this.lastUpdatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationAllOf {\n");
        sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    iconUrl: ").append(this.toIndentedString(this.iconUrl)).append("\n");
        sb.append("    businessLastRead: ").append(this.toIndentedString(this.businessLastRead)).append("\n");
        sb.append("    lastUpdatedAt: ").append(this.toIndentedString(this.lastUpdatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

