/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"id", "type", "guid", "clientId", "status", "integrationId", "lastSeen", "pushNotificationToken", "info", "appVersion"})
public class Device {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    private String clientId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_INTEGRATION_ID = "integrationId";
    private String integrationId;
    public static final String JSON_PROPERTY_LAST_SEEN = "lastSeen";
    private String lastSeen;
    public static final String JSON_PROPERTY_PUSH_NOTIFICATION_TOKEN = "pushNotificationToken";
    private JsonNullable<String> pushNotificationToken = JsonNullable.undefined();
    public static final String JSON_PROPERTY_INFO = "info";
    private JsonNullable<Object> info = JsonNullable.undefined();
    public static final String JSON_PROPERTY_APP_VERSION = "appVersion";
    private JsonNullable<String> appVersion = JsonNullable.undefined();

    public Device id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="de13bee15b51033b34162411", value="The unique ID of the device.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Device type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of integration that the device represents.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Device guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique identifier for the device, generated client-side by the SDK.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public Device clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the client to which this device is associated.")
    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Device status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The device status. Indicates if the device will receive push notifications or not.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Device integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the integration that the device was created for.")
    @JsonProperty(value="integrationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public Device lastSeen(String lastSeen) {
        this.lastSeen = lastSeen;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A datetime string with the format YYYY-MM-DDThh:mm:ss.SSSZ representing the last time the user interacted with this device.")
    @JsonProperty(value="lastSeen")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(String lastSeen) {
        this.lastSeen = lastSeen;
    }

    public Device pushNotificationToken(String pushNotificationToken) {
        this.pushNotificationToken = JsonNullable.of((Object)pushNotificationToken);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The token used for push notifications on Android and iOS devices.")
    @JsonIgnore
    public String getPushNotificationToken() {
        return (String)this.pushNotificationToken.orElse(null);
    }

    @JsonProperty(value="pushNotificationToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPushNotificationToken_JsonNullable() {
        return this.pushNotificationToken;
    }

    @JsonProperty(value="pushNotificationToken")
    public void setPushNotificationToken_JsonNullable(JsonNullable<String> pushNotificationToken) {
        this.pushNotificationToken = pushNotificationToken;
    }

    public void setPushNotificationToken(String pushNotificationToken) {
        this.pushNotificationToken = JsonNullable.of((Object)pushNotificationToken);
    }

    public Device info(Object info) {
        this.info = JsonNullable.of((Object)info);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A flat curated object with properties that vary for each SDK platform. All keys are optional and not guaranteed to be available.")
    @JsonIgnore
    public Object getInfo() {
        return this.info.orElse(null);
    }

    @JsonProperty(value="info")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getInfo_JsonNullable() {
        return this.info;
    }

    @JsonProperty(value="info")
    public void setInfo_JsonNullable(JsonNullable<Object> info) {
        this.info = info;
    }

    public void setInfo(Object info) {
        this.info = JsonNullable.of((Object)info);
    }

    public Device appVersion(String appVersion) {
        this.appVersion = JsonNullable.of((Object)appVersion);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Version of the mobile app in which the SDK is embedded. Not applicable for devices of type web.")
    @JsonIgnore
    public String getAppVersion() {
        return (String)this.appVersion.orElse(null);
    }

    @JsonProperty(value="appVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAppVersion_JsonNullable() {
        return this.appVersion;
    }

    @JsonProperty(value="appVersion")
    public void setAppVersion_JsonNullable(JsonNullable<String> appVersion) {
        this.appVersion = appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = JsonNullable.of((Object)appVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        return Objects.equals(this.id, device.id) && Objects.equals((Object)this.type, (Object)device.type) && Objects.equals(this.guid, device.guid) && Objects.equals(this.clientId, device.clientId) && Objects.equals((Object)this.status, (Object)device.status) && Objects.equals(this.integrationId, device.integrationId) && Objects.equals(this.lastSeen, device.lastSeen) && Objects.equals(this.pushNotificationToken, device.pushNotificationToken) && Objects.equals(this.info, device.info) && Objects.equals(this.appVersion, device.appVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.guid, this.clientId, this.status, this.integrationId, this.lastSeen, this.pushNotificationToken, this.info, this.appVersion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Device {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    lastSeen: ").append(this.toIndentedString(this.lastSeen)).append("\n");
        sb.append("    pushNotificationToken: ").append(this.toIndentedString(this.pushNotificationToken)).append("\n");
        sb.append("    info: ").append(this.toIndentedString(this.info)).append("\n");
        sb.append("    appVersion: ").append(this.toIndentedString(this.appVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("active"),
        INACTIVE("inactive");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        ANDROID("android"),
        IOS("ios"),
        WEB("web");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

