/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Content;
import com.zendesk.sunshine_conversations_client.model.FormResponseMessageField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A formResponse type message is a response to a form type message. formResponse type messages are only supported as responses to form messages on Web Messenger and cannot be sent via the API.")
@JsonPropertyOrder(value={"type", "fields", "textFallback"})
public class FormResponseMessage
implements Content {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "formResponse";
    public static final String JSON_PROPERTY_FIELDS = "fields";
    private List<FormResponseMessageField> fields = new ArrayList<FormResponseMessageField>();
    public static final String JSON_PROPERTY_TEXT_FALLBACK = "textFallback";
    private String textFallback;

    public FormResponseMessage type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The type of message.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public FormResponseMessage fields(List<FormResponseMessageField> fields) {
        this.fields = fields;
        return this;
    }

    public FormResponseMessage addFieldsItem(FormResponseMessageField fieldsItem) {
        this.fields.add(fieldsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of field objects that contain the submitted fields.")
    @JsonProperty(value="fields")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<FormResponseMessageField> getFields() {
        return this.fields;
    }

    public void setFields(List<FormResponseMessageField> fields) {
        this.fields = fields;
    }

    @Nullable
    @ApiModelProperty(value="A string containing the `label: value` of all fields, each separated by a newline character.")
    @JsonProperty(value="textFallback")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTextFallback() {
        return this.textFallback;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormResponseMessage formResponseMessage = (FormResponseMessage)o;
        return Objects.equals(this.type, formResponseMessage.type) && Objects.equals(this.fields, formResponseMessage.fields) && Objects.equals(this.textFallback, formResponseMessage.textFallback);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.fields, this.textFallback);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormResponseMessage {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    textFallback: ").append(this.toIndentedString(this.textFallback)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

