/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "name", "label", "text", "email", "select", "quotedMessageId"})
public class FormResponseMessageField {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;
    public static final String JSON_PROPERTY_TEXT = "text";
    private String text;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_SELECT = "select";
    private List<Object> select = null;
    public static final String JSON_PROPERTY_QUOTED_MESSAGE_ID = "quotedMessageId";
    private String quotedMessageId;

    public FormResponseMessageField type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The field type.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public FormResponseMessageField name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the field. Must be unique per form or formResponse.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FormResponseMessageField label(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(required=true, value="The label of the field. What the field is displayed as on Web Messenger.")
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public FormResponseMessageField text(String text) {
        this.text = text;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the response for a text field.")
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public FormResponseMessageField email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the response for a email field.")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public FormResponseMessageField select(List<Object> select) {
        this.select = select;
        return this;
    }

    public FormResponseMessageField addSelectItem(Object selectItem) {
        if (this.select == null) {
            this.select = new ArrayList<Object>();
        }
        this.select.add(selectItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of objects representing the response for a field of type select. Form and formResponse messages only.")
    @JsonProperty(value="select")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getSelect() {
        return this.select;
    }

    public void setSelect(List<Object> select) {
        this.select = select;
    }

    public FormResponseMessageField quotedMessageId(String quotedMessageId) {
        this.quotedMessageId = quotedMessageId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The messageId for the form that this response belongs to.")
    @JsonProperty(value="quotedMessageId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuotedMessageId() {
        return this.quotedMessageId;
    }

    public void setQuotedMessageId(String quotedMessageId) {
        this.quotedMessageId = quotedMessageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormResponseMessageField formResponseMessageField = (FormResponseMessageField)o;
        return Objects.equals((Object)this.type, (Object)formResponseMessageField.type) && Objects.equals(this.name, formResponseMessageField.name) && Objects.equals(this.label, formResponseMessageField.label) && Objects.equals(this.text, formResponseMessageField.text) && Objects.equals(this.email, formResponseMessageField.email) && Objects.equals(this.select, formResponseMessageField.select) && Objects.equals(this.quotedMessageId, formResponseMessageField.quotedMessageId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.label, this.text, this.email, this.select, this.quotedMessageId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormResponseMessageField {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    select: ").append(this.toIndentedString(this.select)).append("\n");
        sb.append("    quotedMessageId: ").append(this.toIndentedString(this.quotedMessageId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        EMAIL("email"),
        SELECT("select"),
        TEXT("text");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

