/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.api;

import com.zendesk.sunshine_conversations_client.ApiClient;
import com.zendesk.sunshine_conversations_client.ApiException;
import com.zendesk.sunshine_conversations_client.Configuration;
import com.zendesk.sunshine_conversations_client.Pair;
import com.zendesk.sunshine_conversations_client.model.AttachmentDeleteBody;
import com.zendesk.sunshine_conversations_client.model.AttachmentMediaTokenBody;
import com.zendesk.sunshine_conversations_client.model.AttachmentMediaTokenResponse;
import com.zendesk.sunshine_conversations_client.model.AttachmentResponse;
import jakarta.ws.rs.core.GenericType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class AttachmentsApi {
    private ApiClient apiClient;

    public AttachmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AttachmentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Object deleteAttachment(AttachmentDeleteBody attachmentDeleteBody, String appId) throws ApiException {
        AttachmentDeleteBody localVarPostBody = attachmentDeleteBody;
        if (attachmentDeleteBody == null) {
            throw new ApiException(400, "Missing the required parameter 'attachmentDeleteBody' when calling deleteAttachment");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteAttachment");
        }
        String localVarPath = "/v2/apps/{appId}/attachments/remove".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AttachmentMediaTokenResponse generateMediaJsonWebToken(AttachmentMediaTokenBody attachmentMediaTokenBody, String appId) throws ApiException {
        AttachmentMediaTokenBody localVarPostBody = attachmentMediaTokenBody;
        if (attachmentMediaTokenBody == null) {
            throw new ApiException(400, "Missing the required parameter 'attachmentMediaTokenBody' when calling generateMediaJsonWebToken");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling generateMediaJsonWebToken");
        }
        String localVarPath = "/v2/apps/{appId}/attachments/token".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<AttachmentMediaTokenResponse> localVarReturnType = new GenericType<AttachmentMediaTokenResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object setCookie(String appId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling setCookie");
        }
        String localVarPath = "/v2/apps/{appId}/attachments/cookie".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AttachmentResponse uploadAttachment(File source, String appId, String access, String _for, String conversationId) throws ApiException {
        Object localVarPostBody = null;
        if (source == null) {
            throw new ApiException(400, "Missing the required parameter 'source' when calling uploadAttachment");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling uploadAttachment");
        }
        if (access == null) {
            throw new ApiException(400, "Missing the required parameter 'access' when calling uploadAttachment");
        }
        String localVarPath = "/v2/apps/{appId}/attachments".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "access", access));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "for", _for));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "conversationId", conversationId));
        if (source != null) {
            localVarFormParams.put("source", source);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<AttachmentResponse> localVarReturnType = new GenericType<AttachmentResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object deleteAttachment(String bearerToken, AttachmentDeleteBody attachmentDeleteBody, String appId) throws ApiException {
        AttachmentDeleteBody localVarPostBody = attachmentDeleteBody;
        if (attachmentDeleteBody == null) {
            throw new ApiException(400, "Missing the required parameter 'attachmentDeleteBody' when calling deleteAttachment");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteAttachment");
        }
        String localVarPath = "/v2/apps/{appId}/attachments/remove".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AttachmentMediaTokenResponse generateMediaJsonWebToken(String bearerToken, AttachmentMediaTokenBody attachmentMediaTokenBody, String appId) throws ApiException {
        AttachmentMediaTokenBody localVarPostBody = attachmentMediaTokenBody;
        if (attachmentMediaTokenBody == null) {
            throw new ApiException(400, "Missing the required parameter 'attachmentMediaTokenBody' when calling generateMediaJsonWebToken");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling generateMediaJsonWebToken");
        }
        String localVarPath = "/v2/apps/{appId}/attachments/token".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<AttachmentMediaTokenResponse> localVarReturnType = new GenericType<AttachmentMediaTokenResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object setCookie(String bearerToken, String appId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling setCookie");
        }
        String localVarPath = "/v2/apps/{appId}/attachments/cookie".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AttachmentResponse uploadAttachment(String bearerToken, File source, String appId, String access, String _for, String conversationId) throws ApiException {
        Object localVarPostBody = null;
        if (source == null) {
            throw new ApiException(400, "Missing the required parameter 'source' when calling uploadAttachment");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling uploadAttachment");
        }
        if (access == null) {
            throw new ApiException(400, "Missing the required parameter 'access' when calling uploadAttachment");
        }
        String localVarPath = "/v2/apps/{appId}/attachments".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "access", access));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "for", _for));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "conversationId", conversationId));
        if (source != null) {
            localVarFormParams.put("source", source);
        }
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<AttachmentResponse> localVarReturnType = new GenericType<AttachmentResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

