/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "serverKey", "senderId", "canUserCreateMoreConversations"})
public class AndroidAllOf {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "android";
    public static final String JSON_PROPERTY_SERVER_KEY = "serverKey";
    private JsonNullable<String> serverKey = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SENDER_ID = "senderId";
    private JsonNullable<String> senderId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CAN_USER_CREATE_MORE_CONVERSATIONS = "canUserCreateMoreConversations";
    private Boolean canUserCreateMoreConversations;

    public AndroidAllOf type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="To configure an android integration, first visit the [Firebase Console](https://console.firebase.google.com/). Copy the `serverKey` and `senderId` from the Cloud Messaging tab in the settings of your project and call the create integrations endpoint with this data. If you would like to continue using your legacy GCM `serverKey` you can also obtain it from the [Google Developer Console](https://console.developers.google.com/). ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AndroidAllOf serverKey(String serverKey) {
        this.serverKey = JsonNullable.of((Object)serverKey);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="<server-key>", value="Your server key from the fcm console.")
    @JsonIgnore
    public String getServerKey() {
        return (String)this.serverKey.orElse(null);
    }

    @JsonProperty(value="serverKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getServerKey_JsonNullable() {
        return this.serverKey;
    }

    @JsonProperty(value="serverKey")
    public void setServerKey_JsonNullable(JsonNullable<String> serverKey) {
        this.serverKey = serverKey;
    }

    public void setServerKey(String serverKey) {
        this.serverKey = JsonNullable.of((Object)serverKey);
    }

    public AndroidAllOf senderId(String senderId) {
        this.senderId = JsonNullable.of((Object)senderId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="<sender-id>", value="Your sender id from the fcm console.")
    @JsonIgnore
    public String getSenderId() {
        return (String)this.senderId.orElse(null);
    }

    @JsonProperty(value="senderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSenderId_JsonNullable() {
        return this.senderId;
    }

    @JsonProperty(value="senderId")
    public void setSenderId_JsonNullable(JsonNullable<String> senderId) {
        this.senderId = senderId;
    }

    public void setSenderId(String senderId) {
        this.senderId = JsonNullable.of((Object)senderId);
    }

    public AndroidAllOf canUserCreateMoreConversations(Boolean canUserCreateMoreConversations) {
        this.canUserCreateMoreConversations = canUserCreateMoreConversations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allows users to create more than one conversation on the android integration.")
    @JsonProperty(value="canUserCreateMoreConversations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCanUserCreateMoreConversations() {
        return this.canUserCreateMoreConversations;
    }

    public void setCanUserCreateMoreConversations(Boolean canUserCreateMoreConversations) {
        this.canUserCreateMoreConversations = canUserCreateMoreConversations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidAllOf androidAllOf = (AndroidAllOf)o;
        return Objects.equals(this.type, androidAllOf.type) && Objects.equals(this.serverKey, androidAllOf.serverKey) && Objects.equals(this.senderId, androidAllOf.senderId) && Objects.equals(this.canUserCreateMoreConversations, androidAllOf.canUserCreateMoreConversations);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.serverKey, this.senderId, this.canUserCreateMoreConversations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AndroidAllOf {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    serverKey: ").append(this.toIndentedString(this.serverKey)).append("\n");
        sb.append("    senderId: ").append(this.toIndentedString(this.senderId)).append("\n");
        sb.append("    canUserCreateMoreConversations: ").append(this.toIndentedString(this.canUserCreateMoreConversations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

