/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.ConversationTruncated;
import com.zendesk.sunshine_conversations_client.model.Referral;
import com.zendesk.sunshine_conversations_client.model.SourceWithCampaignWebhook;
import com.zendesk.sunshine_conversations_client.model.User;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@ApiModel(description="The payload of the event. The contents of this object depend on the type of event.")
@JsonPropertyOrder(value={"conversation", "user", "source", "referral"})
public class ConversationReferralEventAllOfPayload {
    public static final String JSON_PROPERTY_CONVERSATION = "conversation";
    private ConversationTruncated conversation = null;
    public static final String JSON_PROPERTY_USER = "user";
    private User user = null;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private SourceWithCampaignWebhook source = null;
    public static final String JSON_PROPERTY_REFERRAL = "referral";
    private Referral referral = null;

    public ConversationReferralEventAllOfPayload conversation(ConversationTruncated conversation) {
        this.conversation = conversation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The conversation a user lands in after being referred. See the <a href=\"https://docs.smooch.io/guide/conversation-referrals/\">conversation referrals</a> guide for more details.")
    @JsonProperty(value="conversation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConversationTruncated getConversation() {
        return this.conversation;
    }

    public void setConversation(ConversationTruncated conversation) {
        this.conversation = conversation;
    }

    public ConversationReferralEventAllOfPayload user(User user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user associated with the conversation.")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public ConversationReferralEventAllOfPayload source(SourceWithCampaignWebhook source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source of the referral.")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceWithCampaignWebhook getSource() {
        return this.source;
    }

    public void setSource(SourceWithCampaignWebhook source) {
        this.source = source;
    }

    public ConversationReferralEventAllOfPayload referral(Referral referral) {
        this.referral = referral;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="referral")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Referral getReferral() {
        return this.referral;
    }

    public void setReferral(Referral referral) {
        this.referral = referral;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationReferralEventAllOfPayload conversationReferralEventAllOfPayload = (ConversationReferralEventAllOfPayload)o;
        return Objects.equals(this.conversation, conversationReferralEventAllOfPayload.conversation) && Objects.equals(this.user, conversationReferralEventAllOfPayload.user) && Objects.equals(this.source, conversationReferralEventAllOfPayload.source) && Objects.equals(this.referral, conversationReferralEventAllOfPayload.referral);
    }

    public int hashCode() {
        return Objects.hash(this.conversation, this.user, this.source, this.referral);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationReferralEventAllOfPayload {\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    referral: ").append(this.toIndentedString(this.referral)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

