/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "certificate", "password", "production", "autoUpdateBadge", "canUserCreateMoreConversations"})
public class IosAllOf {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "ios";
    public static final String JSON_PROPERTY_CERTIFICATE = "certificate";
    private JsonNullable<String> certificate = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_PRODUCTION = "production";
    private Boolean production;
    public static final String JSON_PROPERTY_AUTO_UPDATE_BADGE = "autoUpdateBadge";
    private Boolean autoUpdateBadge;
    public static final String JSON_PROPERTY_CAN_USER_CREATE_MORE_CONVERSATIONS = "canUserCreateMoreConversations";
    private Boolean canUserCreateMoreConversations;

    public IosAllOf type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="To configure an ios integration, call the create integration endpoint with a base64 encoded Apple Push Notification certificate from the [Apple Developer Portal](https://developer.apple.com/). ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public IosAllOf certificate(String certificate) {
        this.certificate = JsonNullable.of((Object)certificate);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_APN_certificate", value="The binary of your APN certificate base64 encoded. To base64 encode your certificate you can use this command in the terminal: `openssl base64 -in YOUR_CERTIFICATE.p12 | tr -d '\\n'` ")
    @JsonIgnore
    public String getCertificate() {
        return (String)this.certificate.orElse(null);
    }

    @JsonProperty(value="certificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCertificate_JsonNullable() {
        return this.certificate;
    }

    @JsonProperty(value="certificate")
    public void setCertificate_JsonNullable(JsonNullable<String> certificate) {
        this.certificate = certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = JsonNullable.of((Object)certificate);
    }

    public IosAllOf password(String password) {
        this.password = password;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_APN_password", value="The password for your APN certificate.")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public IosAllOf production(Boolean production) {
        this.production = production;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The APN environment to connect to (Production, if true, or Sandbox). Defaults to value inferred from certificate if not specified.")
    @JsonProperty(value="production")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getProduction() {
        return this.production;
    }

    public void setProduction(Boolean production) {
        this.production = production;
    }

    public IosAllOf autoUpdateBadge(Boolean autoUpdateBadge) {
        this.autoUpdateBadge = autoUpdateBadge;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Use the unread count of the conversation as the application badge.")
    @JsonProperty(value="autoUpdateBadge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutoUpdateBadge() {
        return this.autoUpdateBadge;
    }

    public void setAutoUpdateBadge(Boolean autoUpdateBadge) {
        this.autoUpdateBadge = autoUpdateBadge;
    }

    public IosAllOf canUserCreateMoreConversations(Boolean canUserCreateMoreConversations) {
        this.canUserCreateMoreConversations = canUserCreateMoreConversations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allows users to create more than one conversation on the iOS integration.")
    @JsonProperty(value="canUserCreateMoreConversations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCanUserCreateMoreConversations() {
        return this.canUserCreateMoreConversations;
    }

    public void setCanUserCreateMoreConversations(Boolean canUserCreateMoreConversations) {
        this.canUserCreateMoreConversations = canUserCreateMoreConversations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IosAllOf iosAllOf = (IosAllOf)o;
        return Objects.equals(this.type, iosAllOf.type) && Objects.equals(this.certificate, iosAllOf.certificate) && Objects.equals(this.password, iosAllOf.password) && Objects.equals(this.production, iosAllOf.production) && Objects.equals(this.autoUpdateBadge, iosAllOf.autoUpdateBadge) && Objects.equals(this.canUserCreateMoreConversations, iosAllOf.canUserCreateMoreConversations);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.certificate, this.password, this.production, this.autoUpdateBadge, this.canUserCreateMoreConversations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IosAllOf {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    production: ").append(this.toIndentedString(this.production)).append("\n");
        sb.append("    autoUpdateBadge: ").append(this.toIndentedString(this.autoUpdateBadge)).append("\n");
        sb.append("    canUserCreateMoreConversations: ").append(this.toIndentedString(this.canUserCreateMoreConversations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

