/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.zendesk.sunshine_conversations_client.model.Android;
import com.zendesk.sunshine_conversations_client.model.Apple;
import com.zendesk.sunshine_conversations_client.model.Custom;
import com.zendesk.sunshine_conversations_client.model.Instagram;
import com.zendesk.sunshine_conversations_client.model.Integration;
import com.zendesk.sunshine_conversations_client.model.Ios;
import com.zendesk.sunshine_conversations_client.model.Mailgun;
import com.zendesk.sunshine_conversations_client.model.Messagebird;
import com.zendesk.sunshine_conversations_client.model.Messenger;
import com.zendesk.sunshine_conversations_client.model.Telegram;
import com.zendesk.sunshine_conversations_client.model.Twilio;
import com.zendesk.sunshine_conversations_client.model.Twitter;
import com.zendesk.sunshine_conversations_client.model.Unity;
import com.zendesk.sunshine_conversations_client.model.Viber;
import com.zendesk.sunshine_conversations_client.model.Web;
import com.zendesk.sunshine_conversations_client.model.Whatsapp;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"type", "channelId", "channelSecret", "channelAccessToken", "serviceCode", "switcherSecret", "qrCodeUrl", "lineId"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Android.class, name="android"), @JsonSubTypes.Type(value=Apple.class, name="apple"), @JsonSubTypes.Type(value=Custom.class, name="custom"), @JsonSubTypes.Type(value=Instagram.class, name="instagram"), @JsonSubTypes.Type(value=Ios.class, name="ios"), @JsonSubTypes.Type(value=Line.class, name="line"), @JsonSubTypes.Type(value=Mailgun.class, name="mailgun"), @JsonSubTypes.Type(value=Messagebird.class, name="messagebird"), @JsonSubTypes.Type(value=Messenger.class, name="messenger"), @JsonSubTypes.Type(value=Telegram.class, name="telegram"), @JsonSubTypes.Type(value=Twilio.class, name="twilio"), @JsonSubTypes.Type(value=Twitter.class, name="twitter"), @JsonSubTypes.Type(value=Unity.class, name="unity"), @JsonSubTypes.Type(value=Viber.class, name="viber"), @JsonSubTypes.Type(value=Web.class, name="web"), @JsonSubTypes.Type(value=Whatsapp.class, name="whatsapp")})
public class Line
extends Integration {
    public static final String JSON_PROPERTY_TYPE = "type";
    protected String type = "line";
    public static final String JSON_PROPERTY_CHANNEL_ID = "channelId";
    private String channelId;
    public static final String JSON_PROPERTY_CHANNEL_SECRET = "channelSecret";
    private String channelSecret;
    public static final String JSON_PROPERTY_CHANNEL_ACCESS_TOKEN = "channelAccessToken";
    private String channelAccessToken;
    public static final String JSON_PROPERTY_SERVICE_CODE = "serviceCode";
    private String serviceCode;
    public static final String JSON_PROPERTY_SWITCHER_SECRET = "switcherSecret";
    private String switcherSecret;
    public static final String JSON_PROPERTY_QR_CODE_URL = "qrCodeUrl";
    private String qrCodeUrl;
    public static final String JSON_PROPERTY_LINE_ID = "lineId";
    private String lineId;

    @Override
    public Line type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="For LINE, each of your customers will need to manually configure a webhook in their LINE configuration page that will point to Sunshine Conversations servers. You must instruct your customers how to configure this manually on their LINE bot page. Once you\u2019ve acquired all the required information, call the Create Integration endpoint. Then, using the returned integration _id, your customer must set the Callback URL field in their LINE Business Center page. The URL should look like the following: `https://app.smooch.io:443/api/line/webhooks/{appId}/{integrationId}`. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public Line channelId(String channelId) {
        this.channelId = channelId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1286564967", value="LINE Channel ID. Can be omitted along with `channelSecret` to integrate LINE to setup a webhook before receiving the `channelId` and `channelSecret` back from LINE.")
    @JsonProperty(value="channelId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public Line channelSecret(String channelSecret) {
        this.channelSecret = channelSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_line_channel_secret", value="LINE Channel Secret. Can be omitted along with `channelId` to integrate LINE to setup a webhook before receiving the `channelId` and `channelSecret` back from LINE.")
    @JsonProperty(value="channelSecret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getChannelSecret() {
        return this.channelSecret;
    }

    public void setChannelSecret(String channelSecret) {
        this.channelSecret = channelSecret;
    }

    public Line channelAccessToken(String channelAccessToken) {
        this.channelAccessToken = channelAccessToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_line_channel_token", value="LINE Channel Access Token.")
    @JsonProperty(value="channelAccessToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getChannelAccessToken() {
        return this.channelAccessToken;
    }

    public void setChannelAccessToken(String channelAccessToken) {
        this.channelAccessToken = channelAccessToken;
    }

    public Line serviceCode(String serviceCode) {
        this.serviceCode = serviceCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_line_service_code", value="LINE Service Code.")
    @JsonProperty(value="serviceCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getServiceCode() {
        return this.serviceCode;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public Line switcherSecret(String switcherSecret) {
        this.switcherSecret = switcherSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_line_switcher_secret", value="LINE Switcher Secret.")
    @JsonProperty(value="switcherSecret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSwitcherSecret() {
        return this.switcherSecret;
    }

    public void setSwitcherSecret(String switcherSecret) {
        this.switcherSecret = switcherSecret;
    }

    public Line qrCodeUrl(String qrCodeUrl) {
        this.qrCodeUrl = qrCodeUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://qr-official.line.me/M/1O4fb8.png", value="URL provided by LINE in the [Developer Console](https://developers.line.biz/console/).")
    @JsonProperty(value="qrCodeUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQrCodeUrl() {
        return this.qrCodeUrl;
    }

    public void setQrCodeUrl(String qrCodeUrl) {
        this.qrCodeUrl = qrCodeUrl;
    }

    @Nullable
    @ApiModelProperty(example="104fb8", value="LINE Basic ID. Is automatically set when qrCodeUrl is updated.")
    @JsonProperty(value="lineId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLineId() {
        return this.lineId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Line line = (Line)o;
        return Objects.equals(this.type, line.type) && Objects.equals(this.channelId, line.channelId) && Objects.equals(this.channelSecret, line.channelSecret) && Objects.equals(this.channelAccessToken, line.channelAccessToken) && Objects.equals(this.serviceCode, line.serviceCode) && Objects.equals(this.switcherSecret, line.switcherSecret) && Objects.equals(this.qrCodeUrl, line.qrCodeUrl) && Objects.equals(this.lineId, line.lineId) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.channelId, this.channelSecret, this.channelAccessToken, this.serviceCode, this.switcherSecret, this.qrCodeUrl, this.lineId, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Line {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    channelId: ").append(this.toIndentedString(this.channelId)).append("\n");
        sb.append("    channelSecret: ").append(this.toIndentedString(this.channelSecret)).append("\n");
        sb.append("    channelAccessToken: ").append(this.toIndentedString(this.channelAccessToken)).append("\n");
        sb.append("    serviceCode: ").append(this.toIndentedString(this.serviceCode)).append("\n");
        sb.append("    switcherSecret: ").append(this.toIndentedString(this.switcherSecret)).append("\n");
        sb.append("    qrCodeUrl: ").append(this.toIndentedString(this.qrCodeUrl)).append("\n");
        sb.append("    lineId: ").append(this.toIndentedString(this.lineId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

