/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Action;
import com.zendesk.sunshine_conversations_client.model.ActionSubset;
import com.zendesk.sunshine_conversations_client.model.ExtraChannelOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="A link action will open the provided URI when tapped.")
@JsonPropertyOrder(value={"type", "uri", "text", "default", "metadata", "extraChannelOptions"})
public class Link
implements Action,
ActionSubset {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "link";
    public static final String JSON_PROPERTY_URI = "uri";
    private String uri;
    public static final String JSON_PROPERTY_TEXT = "text";
    private String text;
    public static final String JSON_PROPERTY_DEFAULT = "default";
    private Boolean _default;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private JsonNullable<Object> metadata = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXTRA_CHANNEL_OPTIONS = "extraChannelOptions";
    private ExtraChannelOptions extraChannelOptions;

    public Link type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The type of action.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Link uri(String uri) {
        this.uri = uri;
        return this;
    }

    @ApiModelProperty(required=true, value="The action URI. This is the link that will be used in the clients when clicking the button.")
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Link text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(required=true, value="The button text.")
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Link _default(Boolean _default) {
        this._default = _default;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Boolean value indicating whether the action is the default action for a message item in Facebook Messenger.")
    @JsonProperty(value="default")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDefault() {
        return this._default;
    }

    public void setDefault(Boolean _default) {
        this._default = _default;
    }

    public Link metadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"lang\":\"en-ca\"}", value="Flat object containing custom properties. Strings, numbers and booleans  are the only supported format that can be passed to metadata. The metadata is limited to 4KB in size. ")
    @JsonIgnore
    public Object getMetadata() {
        return this.metadata.orElse(null);
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getMetadata_JsonNullable() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata_JsonNullable(JsonNullable<Object> metadata) {
        this.metadata = metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
    }

    public Link extraChannelOptions(ExtraChannelOptions extraChannelOptions) {
        this.extraChannelOptions = extraChannelOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="extraChannelOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExtraChannelOptions getExtraChannelOptions() {
        return this.extraChannelOptions;
    }

    public void setExtraChannelOptions(ExtraChannelOptions extraChannelOptions) {
        this.extraChannelOptions = extraChannelOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equals(this.type, link.type) && Objects.equals(this.uri, link.uri) && Objects.equals(this.text, link.text) && Objects.equals(this._default, link._default) && Objects.equals(this.metadata, link.metadata) && Objects.equals(this.extraChannelOptions, link.extraChannelOptions);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.uri, this.text, this._default, this.metadata, this.extraChannelOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Link {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    _default: ").append(this.toIndentedString(this._default)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    extraChannelOptions: ").append(this.toIndentedString(this.extraChannelOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

