/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.ConversationTruncated;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@ApiModel(description="Contains information about the conversations that were merged together as a result of the operation, if applicable. If no conversations were merged, this property is omitted.")
@JsonPropertyOrder(value={"surviving", "discarded"})
public class UserMergeEventAllOfPayloadMergedConversations {
    public static final String JSON_PROPERTY_SURVIVING = "surviving";
    private ConversationTruncated surviving = null;
    public static final String JSON_PROPERTY_DISCARDED = "discarded";
    private ConversationTruncated discarded = null;

    public UserMergeEventAllOfPayloadMergedConversations surviving(ConversationTruncated surviving) {
        this.surviving = surviving;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The conversation that now represents the merged conversation object.")
    @JsonProperty(value="surviving")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConversationTruncated getSurviving() {
        return this.surviving;
    }

    public void setSurviving(ConversationTruncated surviving) {
        this.surviving = surviving;
    }

    public UserMergeEventAllOfPayloadMergedConversations discarded(ConversationTruncated discarded) {
        this.discarded = discarded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The conversation that was unified into the surviving conversation object.")
    @JsonProperty(value="discarded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConversationTruncated getDiscarded() {
        return this.discarded;
    }

    public void setDiscarded(ConversationTruncated discarded) {
        this.discarded = discarded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserMergeEventAllOfPayloadMergedConversations userMergeEventAllOfPayloadMergedConversations = (UserMergeEventAllOfPayloadMergedConversations)o;
        return Objects.equals(this.surviving, userMergeEventAllOfPayloadMergedConversations.surviving) && Objects.equals(this.discarded, userMergeEventAllOfPayloadMergedConversations.discarded);
    }

    public int hashCode() {
        return Objects.hash(this.surviving, this.discarded);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserMergeEventAllOfPayloadMergedConversations {\n");
        sb.append("    surviving: ").append(this.toIndentedString(this.surviving)).append("\n");
        sb.append("    discarded: ").append(this.toIndentedString(this.discarded)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

