/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.IntegrationUpdate;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"displayName", "defaultResponderId", "projectId", "clientEmail", "privateKey", "serverKey", "senderId", "canUserCreateMoreConversations"})
public class AndroidUpdate
implements IntegrationUpdate {
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private JsonNullable<String> displayName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEFAULT_RESPONDER_ID = "defaultResponderId";
    private JsonNullable<String> defaultResponderId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PROJECT_ID = "projectId";
    private JsonNullable<String> projectId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CLIENT_EMAIL = "clientEmail";
    private JsonNullable<String> clientEmail = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PRIVATE_KEY = "privateKey";
    private JsonNullable<String> privateKey = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SERVER_KEY = "serverKey";
    private JsonNullable<String> serverKey = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SENDER_ID = "senderId";
    private JsonNullable<String> senderId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CAN_USER_CREATE_MORE_CONVERSATIONS = "canUserCreateMoreConversations";
    private Boolean canUserCreateMoreConversations;

    public AndroidUpdate displayName(String displayName) {
        this.displayName = JsonNullable.of((Object)displayName);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My awesome integration", value="A human-friendly name used to identify the integration. `displayName` can be unset by changing it to `null`.")
    @JsonIgnore
    public String getDisplayName() {
        return (String)this.displayName.orElse(null);
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDisplayName_JsonNullable() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName_JsonNullable(JsonNullable<String> displayName) {
        this.displayName = displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = JsonNullable.of((Object)displayName);
    }

    public AndroidUpdate defaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default responder ID for the integration. This is the ID of the responder that will be used to send messages to the user. For more information, refer to <a href=\"https://docs.smooch.io/guide/switchboard/#per-channel-default-responder\">Per-channel default responder</a> guide. ")
    @JsonIgnore
    public String getDefaultResponderId() {
        return (String)this.defaultResponderId.orElse(null);
    }

    @JsonProperty(value="defaultResponderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDefaultResponderId_JsonNullable() {
        return this.defaultResponderId;
    }

    @JsonProperty(value="defaultResponderId")
    public void setDefaultResponderId_JsonNullable(JsonNullable<String> defaultResponderId) {
        this.defaultResponderId = defaultResponderId;
    }

    public void setDefaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
    }

    public AndroidUpdate projectId(String projectId) {
        this.projectId = JsonNullable.of((Object)projectId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="<project-id>", value="Your project ID from your generated private key file.")
    @JsonIgnore
    public String getProjectId() {
        return (String)this.projectId.orElse(null);
    }

    @JsonProperty(value="projectId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getProjectId_JsonNullable() {
        return this.projectId;
    }

    @JsonProperty(value="projectId")
    public void setProjectId_JsonNullable(JsonNullable<String> projectId) {
        this.projectId = projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = JsonNullable.of((Object)projectId);
    }

    public AndroidUpdate clientEmail(String clientEmail) {
        this.clientEmail = JsonNullable.of((Object)clientEmail);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="<client-email>", value="Your client email from your generated private key file.")
    @JsonIgnore
    public String getClientEmail() {
        return (String)this.clientEmail.orElse(null);
    }

    @JsonProperty(value="clientEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getClientEmail_JsonNullable() {
        return this.clientEmail;
    }

    @JsonProperty(value="clientEmail")
    public void setClientEmail_JsonNullable(JsonNullable<String> clientEmail) {
        this.clientEmail = clientEmail;
    }

    public void setClientEmail(String clientEmail) {
        this.clientEmail = JsonNullable.of((Object)clientEmail);
    }

    public AndroidUpdate privateKey(String privateKey) {
        this.privateKey = JsonNullable.of((Object)privateKey);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="<private-key>", value="Your private key from your generated private key file.")
    @JsonIgnore
    public String getPrivateKey() {
        return (String)this.privateKey.orElse(null);
    }

    @JsonProperty(value="privateKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPrivateKey_JsonNullable() {
        return this.privateKey;
    }

    @JsonProperty(value="privateKey")
    public void setPrivateKey_JsonNullable(JsonNullable<String> privateKey) {
        this.privateKey = privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = JsonNullable.of((Object)privateKey);
    }

    public AndroidUpdate serverKey(String serverKey) {
        this.serverKey = JsonNullable.of((Object)serverKey);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="<server-key>", value="Your server key from the fcm console.")
    @JsonIgnore
    public String getServerKey() {
        return (String)this.serverKey.orElse(null);
    }

    @JsonProperty(value="serverKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getServerKey_JsonNullable() {
        return this.serverKey;
    }

    @JsonProperty(value="serverKey")
    public void setServerKey_JsonNullable(JsonNullable<String> serverKey) {
        this.serverKey = serverKey;
    }

    public void setServerKey(String serverKey) {
        this.serverKey = JsonNullable.of((Object)serverKey);
    }

    public AndroidUpdate senderId(String senderId) {
        this.senderId = JsonNullable.of((Object)senderId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="<sender-id>", value="Your sender id from the fcm console.")
    @JsonIgnore
    public String getSenderId() {
        return (String)this.senderId.orElse(null);
    }

    @JsonProperty(value="senderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSenderId_JsonNullable() {
        return this.senderId;
    }

    @JsonProperty(value="senderId")
    public void setSenderId_JsonNullable(JsonNullable<String> senderId) {
        this.senderId = senderId;
    }

    public void setSenderId(String senderId) {
        this.senderId = JsonNullable.of((Object)senderId);
    }

    public AndroidUpdate canUserCreateMoreConversations(Boolean canUserCreateMoreConversations) {
        this.canUserCreateMoreConversations = canUserCreateMoreConversations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allows users to create more than one conversation on the android integration.")
    @JsonProperty(value="canUserCreateMoreConversations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCanUserCreateMoreConversations() {
        return this.canUserCreateMoreConversations;
    }

    public void setCanUserCreateMoreConversations(Boolean canUserCreateMoreConversations) {
        this.canUserCreateMoreConversations = canUserCreateMoreConversations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidUpdate androidUpdate = (AndroidUpdate)o;
        return Objects.equals(this.displayName, androidUpdate.displayName) && Objects.equals(this.defaultResponderId, androidUpdate.defaultResponderId) && Objects.equals(this.projectId, androidUpdate.projectId) && Objects.equals(this.clientEmail, androidUpdate.clientEmail) && Objects.equals(this.privateKey, androidUpdate.privateKey) && Objects.equals(this.serverKey, androidUpdate.serverKey) && Objects.equals(this.senderId, androidUpdate.senderId) && Objects.equals(this.canUserCreateMoreConversations, androidUpdate.canUserCreateMoreConversations);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.defaultResponderId, this.projectId, this.clientEmail, this.privateKey, this.serverKey, this.senderId, this.canUserCreateMoreConversations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AndroidUpdate {\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    defaultResponderId: ").append(this.toIndentedString(this.defaultResponderId)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    clientEmail: ").append(this.toIndentedString(this.clientEmail)).append("\n");
        sb.append("    privateKey: ").append(this.toIndentedString(this.privateKey)).append("\n");
        sb.append("    serverKey: ").append(this.toIndentedString(this.serverKey)).append("\n");
        sb.append("    senderId: ").append(this.toIndentedString(this.senderId)).append("\n");
        sb.append("    canUserCreateMoreConversations: ").append(this.toIndentedString(this.canUserCreateMoreConversations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

