/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"mediaUrl", "mediaType"})
public class AttachmentSchema {
    public static final String JSON_PROPERTY_MEDIA_URL = "mediaUrl";
    private String mediaUrl;
    public static final String JSON_PROPERTY_MEDIA_TYPE = "mediaType";
    private String mediaType;

    public AttachmentSchema mediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://smooch.io/rocks.smooch.media-dev/apps/5ec41c54fe13cc5ac404bedc/conversations/c616a583e4c240a871818541/TmYMVQUBNsQRItX4fKf4aC-T/Screen%20Shot%202020-09-02%20at%204.04.41%20PM.png", value="Uploaded attachment\u2019s url")
    @JsonProperty(value="mediaUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMediaUrl() {
        return this.mediaUrl;
    }

    public void setMediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
    }

    public AttachmentSchema mediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="image/png", value="Uploaded attachment's media type")
    @JsonProperty(value="mediaType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentSchema attachmentSchema = (AttachmentSchema)o;
        return Objects.equals(this.mediaUrl, attachmentSchema.mediaUrl) && Objects.equals(this.mediaType, attachmentSchema.mediaType);
    }

    public int hashCode() {
        return Objects.hash(this.mediaUrl, this.mediaType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttachmentSchema {\n");
        sb.append("    mediaUrl: ").append(this.toIndentedString(this.mediaUrl)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

