/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.CarouselMessageDisplaySettings;
import com.zendesk.sunshine_conversations_client.model.Content;
import com.zendesk.sunshine_conversations_client.model.Item;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Carousel messages are a horizontally scrollable set of items that may each contain text, an image, and message actions. Not all messaging channels fully support carousel messages; currently only Facebook Messenger, LINE, Telegram, Viber, the Web Messenger, the Android SDK and the iOS SDK cover the full functionality. For all other platforms a carousel message is rendered as raw text. The raw text fallback does not include any images or postback message actions.")
@JsonPropertyOrder(value={"type", "text", "items", "displaySettings"})
public class CarouselMessage
implements Content {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "carousel";
    public static final String JSON_PROPERTY_TEXT = "text";
    private String text;
    public static final String JSON_PROPERTY_ITEMS = "items";
    private List<Item> items = new ArrayList<Item>();
    public static final String JSON_PROPERTY_DISPLAY_SETTINGS = "displaySettings";
    private CarouselMessageDisplaySettings displaySettings;

    public CarouselMessage type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The type of message.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Nullable
    @ApiModelProperty(value="The fallback text message used when carousel messages are not supported by the channel.")
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getText() {
        return this.text;
    }

    public CarouselMessage items(List<Item> items) {
        this.items = items;
        return this;
    }

    public CarouselMessage addItemsItem(Item itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of objects representing the items associated with the message. Only present in carousel and list type messages.")
    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public CarouselMessage displaySettings(CarouselMessageDisplaySettings displaySettings) {
        this.displaySettings = displaySettings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="displaySettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CarouselMessageDisplaySettings getDisplaySettings() {
        return this.displaySettings;
    }

    public void setDisplaySettings(CarouselMessageDisplaySettings displaySettings) {
        this.displaySettings = displaySettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CarouselMessage carouselMessage = (CarouselMessage)o;
        return Objects.equals(this.type, carouselMessage.type) && Objects.equals(this.text, carouselMessage.text) && Objects.equals(this.items, carouselMessage.items) && Objects.equals(this.displaySettings, carouselMessage.displaySettings);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.text, this.items, this.displaySettings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CarouselMessage {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    displaySettings: ").append(this.toIndentedString(this.displaySettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

