/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.zendesk.sunshine_conversations_client.model.Client;
import com.zendesk.sunshine_conversations_client.model.ConversationTruncated;
import com.zendesk.sunshine_conversations_client.model.SourceWebhook;
import com.zendesk.sunshine_conversations_client.model.UserTruncated;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The payload of the event. The contents of this object depend on the type of event.")
@JsonPropertyOrder(value={"conversation", "user", "client", "reason", "error", "source"})
public class ClientRemoveEventAllOfPayload {
    public static final String JSON_PROPERTY_CONVERSATION = "conversation";
    private JsonNullable<ConversationTruncated> conversation = JsonNullable.of(null);
    public static final String JSON_PROPERTY_USER = "user";
    private UserTruncated user = null;
    public static final String JSON_PROPERTY_CLIENT = "client";
    private Client client = null;
    public static final String JSON_PROPERTY_REASON = "reason";
    private ReasonEnum reason;
    public static final String JSON_PROPERTY_ERROR = "error";
    private JsonNullable<Object> error = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SOURCE = "source";
    private SourceWebhook source = null;

    public ClientRemoveEventAllOfPayload conversation(ConversationTruncated conversation) {
        this.conversation = JsonNullable.of((Object)conversation);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The conversation associated with the removal of the client. This field is only present when the reason is `theft`, `linkCancelled` or `linkFailed`. Note that for the `theft` reason, the conversation will not be present if it has been deleted. ")
    @JsonIgnore
    public ConversationTruncated getConversation() {
        return (ConversationTruncated)this.conversation.orElse(null);
    }

    @JsonProperty(value="conversation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<ConversationTruncated> getConversation_JsonNullable() {
        return this.conversation;
    }

    @JsonProperty(value="conversation")
    public void setConversation_JsonNullable(JsonNullable<ConversationTruncated> conversation) {
        this.conversation = conversation;
    }

    public void setConversation(ConversationTruncated conversation) {
        this.conversation = JsonNullable.of((Object)conversation);
    }

    public ClientRemoveEventAllOfPayload user(UserTruncated user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user associated with the client.")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserTruncated getUser() {
        return this.user;
    }

    public void setUser(UserTruncated user) {
        this.user = user;
    }

    public ClientRemoveEventAllOfPayload client(Client client) {
        this.client = client;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The removed client.")
    @JsonProperty(value="client")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public ClientRemoveEventAllOfPayload reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason for which the client was removed. * `api` - The client was removed using the API. * `linkCancelled` - The user cancelled a channel link. * `linkFailed` - The client was removed after a channel link attempt failed. * `sdk` - The client was removed using the SDK. * `theft` - The client was transferred to another user due to a channel link. ")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReasonEnum getReason() {
        return this.reason;
    }

    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public ClientRemoveEventAllOfPayload error(Object error) {
        this.error = JsonNullable.of((Object)error);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Object containing details of what went wrong. This field will only be present when the reason is `linkCancelled` or `linkFailed`.")
    @JsonIgnore
    public Object getError() {
        return this.error.orElse(null);
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getError_JsonNullable() {
        return this.error;
    }

    @JsonProperty(value="error")
    public void setError_JsonNullable(JsonNullable<Object> error) {
        this.error = error;
    }

    public void setError(Object error) {
        this.error = JsonNullable.of((Object)error);
    }

    public ClientRemoveEventAllOfPayload source(SourceWebhook source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source where this event originated from. This could be the API or an SDK device.")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceWebhook getSource() {
        return this.source;
    }

    public void setSource(SourceWebhook source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientRemoveEventAllOfPayload clientRemoveEventAllOfPayload = (ClientRemoveEventAllOfPayload)o;
        return Objects.equals(this.conversation, clientRemoveEventAllOfPayload.conversation) && Objects.equals(this.user, clientRemoveEventAllOfPayload.user) && Objects.equals(this.client, clientRemoveEventAllOfPayload.client) && Objects.equals((Object)this.reason, (Object)clientRemoveEventAllOfPayload.reason) && Objects.equals(this.error, clientRemoveEventAllOfPayload.error) && Objects.equals(this.source, clientRemoveEventAllOfPayload.source);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conversation, this.user, this.client, this.reason, this.error, this.source});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClientRemoveEventAllOfPayload {\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    client: ").append(this.toIndentedString(this.client)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ReasonEnum {
        API("api"),
        LINKCANCELLED("linkCancelled"),
        LINKFAILED("linkFailed"),
        SDK("sdk"),
        THEFT("theft");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

