/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.ConversationMessageDeliveryPayloadDestination;
import com.zendesk.sunshine_conversations_client.model.ConversationMessageDeliveryPayloadExternalMessages;
import com.zendesk.sunshine_conversations_client.model.ConversationMessageDeliveryPayloadMessage;
import com.zendesk.sunshine_conversations_client.model.ConversationTruncated;
import com.zendesk.sunshine_conversations_client.model.User;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The payload of the event. The contents of this object depend on the type of event.")
@JsonPropertyOrder(value={"user", "conversation", "message", "destination", "externalMessages", "isFinalEvent"})
public class ConversationMessageDeliveryPayload {
    public static final String JSON_PROPERTY_USER = "user";
    private User user = null;
    public static final String JSON_PROPERTY_CONVERSATION = "conversation";
    private ConversationTruncated conversation = null;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private ConversationMessageDeliveryPayloadMessage message;
    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private ConversationMessageDeliveryPayloadDestination destination;
    public static final String JSON_PROPERTY_EXTERNAL_MESSAGES = "externalMessages";
    private JsonNullable<List<ConversationMessageDeliveryPayloadExternalMessages>> externalMessages = JsonNullable.undefined();
    public static final String JSON_PROPERTY_IS_FINAL_EVENT = "isFinalEvent";
    private Boolean isFinalEvent;

    public ConversationMessageDeliveryPayload user(User user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user associated with the conversation.")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public ConversationMessageDeliveryPayload conversation(ConversationTruncated conversation) {
        this.conversation = conversation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The conversation in which the message was sent.")
    @JsonProperty(value="conversation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConversationTruncated getConversation() {
        return this.conversation;
    }

    public void setConversation(ConversationTruncated conversation) {
        this.conversation = conversation;
    }

    public ConversationMessageDeliveryPayload message(ConversationMessageDeliveryPayloadMessage message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConversationMessageDeliveryPayloadMessage getMessage() {
        return this.message;
    }

    public void setMessage(ConversationMessageDeliveryPayloadMessage message) {
        this.message = message;
    }

    public ConversationMessageDeliveryPayload destination(ConversationMessageDeliveryPayloadDestination destination) {
        this.destination = destination;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConversationMessageDeliveryPayloadDestination getDestination() {
        return this.destination;
    }

    public void setDestination(ConversationMessageDeliveryPayloadDestination destination) {
        this.destination = destination;
    }

    public ConversationMessageDeliveryPayload externalMessages(List<ConversationMessageDeliveryPayloadExternalMessages> externalMessages) {
        this.externalMessages = JsonNullable.of(externalMessages);
        return this;
    }

    public ConversationMessageDeliveryPayload addExternalMessagesItem(ConversationMessageDeliveryPayloadExternalMessages externalMessagesItem) {
        if (this.externalMessages == null || !this.externalMessages.isPresent()) {
            this.externalMessages = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.externalMessages.get()).add(externalMessagesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of objects representing the third-party messages associated with the event. The order of the external messages is not guaranteed to be the same across the different triggers. Note that some channels don\u2019t expose message IDs, in which case this field will be unset.")
    @JsonIgnore
    public List<ConversationMessageDeliveryPayloadExternalMessages> getExternalMessages() {
        return (List)this.externalMessages.orElse(null);
    }

    @JsonProperty(value="externalMessages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<ConversationMessageDeliveryPayloadExternalMessages>> getExternalMessages_JsonNullable() {
        return this.externalMessages;
    }

    @JsonProperty(value="externalMessages")
    public void setExternalMessages_JsonNullable(JsonNullable<List<ConversationMessageDeliveryPayloadExternalMessages>> externalMessages) {
        this.externalMessages = externalMessages;
    }

    public void setExternalMessages(List<ConversationMessageDeliveryPayloadExternalMessages> externalMessages) {
        this.externalMessages = JsonNullable.of(externalMessages);
    }

    public ConversationMessageDeliveryPayload isFinalEvent(Boolean isFinalEvent) {
        this.isFinalEvent = isFinalEvent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A boolean indicating whether the webhook is the final one for the `message.id` and `destination.type` pair.")
    @JsonProperty(value="isFinalEvent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsFinalEvent() {
        return this.isFinalEvent;
    }

    public void setIsFinalEvent(Boolean isFinalEvent) {
        this.isFinalEvent = isFinalEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationMessageDeliveryPayload conversationMessageDeliveryPayload = (ConversationMessageDeliveryPayload)o;
        return Objects.equals(this.user, conversationMessageDeliveryPayload.user) && Objects.equals(this.conversation, conversationMessageDeliveryPayload.conversation) && Objects.equals(this.message, conversationMessageDeliveryPayload.message) && Objects.equals(this.destination, conversationMessageDeliveryPayload.destination) && Objects.equals(this.externalMessages, conversationMessageDeliveryPayload.externalMessages) && Objects.equals(this.isFinalEvent, conversationMessageDeliveryPayload.isFinalEvent);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.conversation, this.message, this.destination, this.externalMessages, this.isFinalEvent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationMessageDeliveryPayload {\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    externalMessages: ").append(this.toIndentedString(this.externalMessages)).append("\n");
        sb.append("    isFinalEvent: ").append(this.toIndentedString(this.isFinalEvent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

