/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Content;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Objects;

@JsonPropertyOrder(value={"type", "mediaUrl", "mediaSize", "mediaType", "altText", "text"})
public class FileMessage
implements Content {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "file";
    public static final String JSON_PROPERTY_MEDIA_URL = "mediaUrl";
    private URI mediaUrl;
    public static final String JSON_PROPERTY_MEDIA_SIZE = "mediaSize";
    private BigDecimal mediaSize;
    public static final String JSON_PROPERTY_MEDIA_TYPE = "mediaType";
    private String mediaType;
    public static final String JSON_PROPERTY_ALT_TEXT = "altText";
    private String altText;
    public static final String JSON_PROPERTY_TEXT = "text";
    private String text;

    public FileMessage type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The type of message.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public FileMessage mediaUrl(URI mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="The URL for media, such as an image, attached to the message.")
    @JsonProperty(value="mediaUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getMediaUrl() {
        return this.mediaUrl;
    }

    public void setMediaUrl(URI mediaUrl) {
        this.mediaUrl = mediaUrl;
    }

    @Nullable
    @ApiModelProperty(value="The size of the media.")
    @JsonProperty(value="mediaSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getMediaSize() {
        return this.mediaSize;
    }

    @Nullable
    @ApiModelProperty(value="The media type of the file.")
    @JsonProperty(value="mediaType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMediaType() {
        return this.mediaType;
    }

    public FileMessage altText(String altText) {
        this.altText = altText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional description of the file for accessibility purposes. The field will be saved by default with the file name as the value.")
    @JsonProperty(value="altText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAltText() {
        return this.altText;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public FileMessage text(String text) {
        this.text = text;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The text content of the message.")
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileMessage fileMessage = (FileMessage)o;
        return Objects.equals(this.type, fileMessage.type) && Objects.equals(this.mediaUrl, fileMessage.mediaUrl) && Objects.equals(this.mediaSize, fileMessage.mediaSize) && Objects.equals(this.mediaType, fileMessage.mediaType) && Objects.equals(this.altText, fileMessage.altText) && Objects.equals(this.text, fileMessage.text);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.mediaUrl, this.mediaSize, this.mediaType, this.altText, this.text);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileMessage {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    mediaUrl: ").append(this.toIndentedString(this.mediaUrl)).append("\n");
        sb.append("    mediaSize: ").append(this.toIndentedString(this.mediaSize)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("    altText: ").append(this.toIndentedString(this.altText)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

