/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Properties that can be expected to receive inside a form message field. ")
@JsonPropertyOrder(value={"placeholder", "minSize", "maxSize", "options"})
public class FormMessageFieldAllOf {
    public static final String JSON_PROPERTY_PLACEHOLDER = "placeholder";
    private String placeholder;
    public static final String JSON_PROPERTY_MIN_SIZE = "minSize";
    private Integer minSize = 1;
    public static final String JSON_PROPERTY_MAX_SIZE = "maxSize";
    private Integer maxSize = 128;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private List<Object> options = null;

    public FormMessageFieldAllOf placeholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Placeholder text for the field. Form message only.")
    @JsonProperty(value="placeholder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public FormMessageFieldAllOf minSize(Integer minSize) {
        this.minSize = minSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum allowed length for the response for a field of type text. Form message only.")
    @JsonProperty(value="minSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinSize() {
        return this.minSize;
    }

    public void setMinSize(Integer minSize) {
        this.minSize = minSize;
    }

    public FormMessageFieldAllOf maxSize(Integer maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum allowed length for the response for a field of type text. Form message only.")
    @JsonProperty(value="maxSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public FormMessageFieldAllOf options(List<Object> options) {
        this.options = options;
        return this;
    }

    public FormMessageFieldAllOf addOptionsItem(Object optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<Object>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of objects representing options for a field of type select.")
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getOptions() {
        return this.options;
    }

    public void setOptions(List<Object> options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormMessageFieldAllOf formMessageFieldAllOf = (FormMessageFieldAllOf)o;
        return Objects.equals(this.placeholder, formMessageFieldAllOf.placeholder) && Objects.equals(this.minSize, formMessageFieldAllOf.minSize) && Objects.equals(this.maxSize, formMessageFieldAllOf.maxSize) && Objects.equals(this.options, formMessageFieldAllOf.options);
    }

    public int hashCode() {
        return Objects.hash(this.placeholder, this.minSize, this.maxSize, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormMessageFieldAllOf {\n");
        sb.append("    placeholder: ").append(this.toIndentedString(this.placeholder)).append("\n");
        sb.append("    minSize: ").append(this.toIndentedString(this.minSize)).append("\n");
        sb.append("    maxSize: ").append(this.toIndentedString(this.maxSize)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

