/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"certificate", "password", "production", "autoUpdateBadge", "canUserCreateMoreConversations"})
public class IosUpdateAllOf {
    public static final String JSON_PROPERTY_CERTIFICATE = "certificate";
    private JsonNullable<String> certificate = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_PRODUCTION = "production";
    private Boolean production;
    public static final String JSON_PROPERTY_AUTO_UPDATE_BADGE = "autoUpdateBadge";
    private Boolean autoUpdateBadge;
    public static final String JSON_PROPERTY_CAN_USER_CREATE_MORE_CONVERSATIONS = "canUserCreateMoreConversations";
    private Boolean canUserCreateMoreConversations;

    public IosUpdateAllOf certificate(String certificate) {
        this.certificate = JsonNullable.of((Object)certificate);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_APN_certificate", value="The binary of your APN certificate base64 encoded.")
    @JsonIgnore
    public String getCertificate() {
        return (String)this.certificate.orElse(null);
    }

    @JsonProperty(value="certificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCertificate_JsonNullable() {
        return this.certificate;
    }

    @JsonProperty(value="certificate")
    public void setCertificate_JsonNullable(JsonNullable<String> certificate) {
        this.certificate = certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = JsonNullable.of((Object)certificate);
    }

    public IosUpdateAllOf password(String password) {
        this.password = password;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_APN_password", value="The password for your APN certificate.")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public IosUpdateAllOf production(Boolean production) {
        this.production = production;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The APN environment to connect to (Production, if true, or Sandbox). Defaults to value inferred from certificate if not specified.")
    @JsonProperty(value="production")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getProduction() {
        return this.production;
    }

    public void setProduction(Boolean production) {
        this.production = production;
    }

    public IosUpdateAllOf autoUpdateBadge(Boolean autoUpdateBadge) {
        this.autoUpdateBadge = autoUpdateBadge;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Use the unread count of the conversation as the application badge.")
    @JsonProperty(value="autoUpdateBadge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutoUpdateBadge() {
        return this.autoUpdateBadge;
    }

    public void setAutoUpdateBadge(Boolean autoUpdateBadge) {
        this.autoUpdateBadge = autoUpdateBadge;
    }

    public IosUpdateAllOf canUserCreateMoreConversations(Boolean canUserCreateMoreConversations) {
        this.canUserCreateMoreConversations = canUserCreateMoreConversations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allows users to create more than one conversation on the iOS integration.")
    @JsonProperty(value="canUserCreateMoreConversations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCanUserCreateMoreConversations() {
        return this.canUserCreateMoreConversations;
    }

    public void setCanUserCreateMoreConversations(Boolean canUserCreateMoreConversations) {
        this.canUserCreateMoreConversations = canUserCreateMoreConversations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IosUpdateAllOf iosUpdateAllOf = (IosUpdateAllOf)o;
        return Objects.equals(this.certificate, iosUpdateAllOf.certificate) && Objects.equals(this.password, iosUpdateAllOf.password) && Objects.equals(this.production, iosUpdateAllOf.production) && Objects.equals(this.autoUpdateBadge, iosUpdateAllOf.autoUpdateBadge) && Objects.equals(this.canUserCreateMoreConversations, iosUpdateAllOf.canUserCreateMoreConversations);
    }

    public int hashCode() {
        return Objects.hash(this.certificate, this.password, this.production, this.autoUpdateBadge, this.canUserCreateMoreConversations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IosUpdateAllOf {\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    production: ").append(this.toIndentedString(this.production)).append("\n");
        sb.append("    autoUpdateBadge: ").append(this.toIndentedString(this.autoUpdateBadge)).append("\n");
        sb.append("    canUserCreateMoreConversations: ").append(this.toIndentedString(this.canUserCreateMoreConversations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

