/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Content;
import com.zendesk.sunshine_conversations_client.model.LocationMessageCoordinates;
import com.zendesk.sunshine_conversations_client.model.LocationMessageLocation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@ApiModel(description="A location type message includes the coordinates (latitude and longitude) of a location and an optional location object which can include the name and address of the location. Typically sent in response to a Location Request.")
@JsonPropertyOrder(value={"type", "text", "coordinates", "location"})
public class LocationMessage
implements Content {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "location";
    public static final String JSON_PROPERTY_TEXT = "text";
    private String text;
    public static final String JSON_PROPERTY_COORDINATES = "coordinates";
    private LocationMessageCoordinates coordinates;
    public static final String JSON_PROPERTY_LOCATION = "location";
    private LocationMessageLocation location;

    public LocationMessage type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The type of message.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Nullable
    @ApiModelProperty(value="The fallback text message used when location messages are not supported by the channel.")
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getText() {
        return this.text;
    }

    public LocationMessage coordinates(LocationMessageCoordinates coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="coordinates")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocationMessageCoordinates getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(LocationMessageCoordinates coordinates) {
        this.coordinates = coordinates;
    }

    public LocationMessage location(LocationMessageLocation location) {
        this.location = location;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocationMessageLocation getLocation() {
        return this.location;
    }

    public void setLocation(LocationMessageLocation location) {
        this.location = location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationMessage locationMessage = (LocationMessage)o;
        return Objects.equals(this.type, locationMessage.type) && Objects.equals(this.text, locationMessage.text) && Objects.equals(this.coordinates, locationMessage.coordinates) && Objects.equals(this.location, locationMessage.location);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.text, this.coordinates, this.location);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LocationMessage {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    coordinates: ").append(this.toIndentedString(this.coordinates)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

