/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Links;
import com.zendesk.sunshine_conversations_client.model.Message;
import com.zendesk.sunshine_conversations_client.model.Meta;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"messages", "meta", "links"})
public class MessageListResponse {
    public static final String JSON_PROPERTY_MESSAGES = "messages";
    private List<Message> messages = null;
    public static final String JSON_PROPERTY_META = "meta";
    private Meta meta;
    public static final String JSON_PROPERTY_LINKS = "links";
    private Links links;

    public MessageListResponse messages(List<Message> messages) {
        this.messages = messages;
        return this;
    }

    public MessageListResponse addMessagesItem(Message messagesItem) {
        if (this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        this.messages.add(messagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of returned messages.")
    @JsonProperty(value="messages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public MessageListResponse meta(Meta meta) {
        this.meta = meta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Meta getMeta() {
        return this.meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public MessageListResponse links(Links links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Links getLinks() {
        return this.links;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageListResponse messageListResponse = (MessageListResponse)o;
        return Objects.equals(this.messages, messageListResponse.messages) && Objects.equals(this.meta, messageListResponse.meta) && Objects.equals(this.links, messageListResponse.links);
    }

    public int hashCode() {
        return Objects.hash(this.messages, this.meta, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageListResponse {\n");
        sb.append("    messages: ").append(this.toIndentedString(this.messages)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

