/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"after", "before", "size"})
public class Page {
    public static final String JSON_PROPERTY_AFTER = "after";
    private String after;
    public static final String JSON_PROPERTY_BEFORE = "before";
    private String before;
    public static final String JSON_PROPERTY_SIZE = "size";
    private Integer size = 25;

    public Page after(String after) {
        this.after = after;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5e1606762556d93e9c176f69", value="A record id. Results will only contain the records that come after the specified record.  Only one of `after` or `before` can be provided, not both. ")
    @JsonProperty(value="after")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAfter() {
        return this.after;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public Page before(String before) {
        this.before = before;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5e1606762556d93e9c176f69", value="A record id. Results will only contain the records that come before the specified record. Only one of `after` or `before` can be provided, not both. ")
    @JsonProperty(value="before")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBefore() {
        return this.before;
    }

    public void setBefore(String before) {
        this.before = before;
    }

    public Page size(Integer size) {
        this.size = size;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="The number of records to return. Does not apply to the `listMessages` endpoint.")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Page page = (Page)o;
        return Objects.equals(this.after, page.after) && Objects.equals(this.before, page.before) && Objects.equals(this.size, page.size);
    }

    public int hashCode() {
        return Objects.hash(this.after, this.before, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Page {\n");
        sb.append("    after: ").append(this.toIndentedString(this.after)).append("\n");
        sb.append("    before: ").append(this.toIndentedString(this.before)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

