/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Identity;
import com.zendesk.sunshine_conversations_client.model.Profile;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"id", "externalId", "signedUpAt", "profile", "metadata", "identities"})
public class User {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
    private JsonNullable<String> externalId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SIGNED_UP_AT = "signedUpAt";
    private String signedUpAt = null;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Profile profile = null;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Object metadata = null;
    public static final String JSON_PROPERTY_IDENTITIES = "identities";
    private List<Identity> identities = null;

    public User id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="7494535bff5cef41a15be74d", value="The unique ID of the user.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public User externalId(String externalId) {
        this.externalId = JsonNullable.of((Object)externalId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-own-id", value="An optional ID that can also be used to retrieve the user. ")
    @JsonIgnore
    public String getExternalId() {
        return (String)this.externalId.orElse(null);
    }

    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getExternalId_JsonNullable() {
        return this.externalId;
    }

    @JsonProperty(value="externalId")
    public void setExternalId_JsonNullable(JsonNullable<String> externalId) {
        this.externalId = externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = JsonNullable.of((Object)externalId);
    }

    public User signedUpAt(String signedUpAt) {
        this.signedUpAt = signedUpAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="signedUpAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSignedUpAt() {
        return this.signedUpAt;
    }

    public void setSignedUpAt(String signedUpAt) {
        this.signedUpAt = signedUpAt;
    }

    public User profile(Profile profile) {
        this.profile = profile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public User metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    @Nullable
    @ApiModelProperty(value="The user's connected identities.")
    @JsonProperty(value="identities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Identity> getIdentities() {
        return this.identities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.id, user.id) && Objects.equals(this.externalId, user.externalId) && Objects.equals(this.signedUpAt, user.signedUpAt) && Objects.equals(this.profile, user.profile) && Objects.equals(this.metadata, user.metadata) && Objects.equals(this.identities, user.identities);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.externalId, this.signedUpAt, this.profile, this.metadata, this.identities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    signedUpAt: ").append(this.toIndentedString(this.signedUpAt)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    identities: ").append(this.toIndentedString(this.identities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

