/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.zendesk.sunshine_conversations_client.model.ClientType;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"id", "type", "status", "integrationId", "externalId", "lastSeen", "linkedAt", "displayName", "avatarUrl", "info", "raw"})
public class Client {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ClientType type;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_INTEGRATION_ID = "integrationId";
    private JsonNullable<String> integrationId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
    private JsonNullable<String> externalId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LAST_SEEN = "lastSeen";
    private JsonNullable<String> lastSeen = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LINKED_AT = "linkedAt";
    private JsonNullable<String> linkedAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private JsonNullable<String> displayName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_AVATAR_URL = "avatarUrl";
    private JsonNullable<URI> avatarUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_INFO = "info";
    private JsonNullable<Object> info = JsonNullable.undefined();
    public static final String JSON_PROPERTY_RAW = "raw";
    private JsonNullable<Object> raw = JsonNullable.undefined();

    public Client id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5c9a34160c89726709136733", value="The unique ID of the client.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Client type(ClientType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ClientType getType() {
        return this.type;
    }

    public void setType(ClientType type) {
        this.type = type;
    }

    public Client status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="active", value="The client status. Indicates if the client is able to receive messages or not. Can be pending, inactive, active, or blocked.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Client integrationId(String integrationId) {
        this.integrationId = JsonNullable.of((Object)integrationId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="582dedf230e788746891281a", value="The ID of the integration that the client was created for. Unused for clients of type sdk, as they incorporate multiple integrations.")
    @JsonIgnore
    public String getIntegrationId() {
        return (String)this.integrationId.orElse(null);
    }

    @JsonProperty(value="integrationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getIntegrationId_JsonNullable() {
        return this.integrationId;
    }

    @JsonProperty(value="integrationId")
    public void setIntegrationId_JsonNullable(JsonNullable<String> integrationId) {
        this.integrationId = integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = JsonNullable.of((Object)integrationId);
    }

    public Client externalId(String externalId) {
        this.externalId = JsonNullable.of((Object)externalId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-own-id", value="The ID of the user on an external channel. For example, the user\u2019s phone number for Twilio, or their page-scoped user ID for Facebook Messenger. Applies only to non-SDK clients.")
    @JsonIgnore
    public String getExternalId() {
        return (String)this.externalId.orElse(null);
    }

    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getExternalId_JsonNullable() {
        return this.externalId;
    }

    @JsonProperty(value="externalId")
    public void setExternalId_JsonNullable(JsonNullable<String> externalId) {
        this.externalId = externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = JsonNullable.of((Object)externalId);
    }

    public Client lastSeen(String lastSeen) {
        this.lastSeen = JsonNullable.of((Object)lastSeen);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-08-20T16:13:07.462Z", value="A datetime string with the format `YYYY-MM-DDThh:mm:ss.SSSZ` representing the last time the user interacted with this client.")
    @JsonIgnore
    public String getLastSeen() {
        return (String)this.lastSeen.orElse(null);
    }

    @JsonProperty(value="lastSeen")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getLastSeen_JsonNullable() {
        return this.lastSeen;
    }

    @JsonProperty(value="lastSeen")
    public void setLastSeen_JsonNullable(JsonNullable<String> lastSeen) {
        this.lastSeen = lastSeen;
    }

    public void setLastSeen(String lastSeen) {
        this.lastSeen = JsonNullable.of((Object)lastSeen);
    }

    public Client linkedAt(String linkedAt) {
        this.linkedAt = JsonNullable.of((Object)linkedAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-06-23T14:33:47.492Z", value="A timestamp signifying when the client was added to the user. Formatted as `YYYY-MM-DDThh:mm:ss.SSSZ`.")
    @JsonIgnore
    public String getLinkedAt() {
        return (String)this.linkedAt.orElse(null);
    }

    @JsonProperty(value="linkedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getLinkedAt_JsonNullable() {
        return this.linkedAt;
    }

    @JsonProperty(value="linkedAt")
    public void setLinkedAt_JsonNullable(JsonNullable<String> linkedAt) {
        this.linkedAt = linkedAt;
    }

    public void setLinkedAt(String linkedAt) {
        this.linkedAt = JsonNullable.of((Object)linkedAt);
    }

    public Client displayName(String displayName) {
        this.displayName = JsonNullable.of((Object)displayName);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Steve", value="The user's display name on the channel.")
    @JsonIgnore
    public String getDisplayName() {
        return (String)this.displayName.orElse(null);
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDisplayName_JsonNullable() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName_JsonNullable(JsonNullable<String> displayName) {
        this.displayName = displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = JsonNullable.of((Object)displayName);
    }

    public Client avatarUrl(URI avatarUrl) {
        this.avatarUrl = JsonNullable.of((Object)avatarUrl);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL for the user's avatar on the channel.")
    @JsonIgnore
    public URI getAvatarUrl() {
        return (URI)this.avatarUrl.orElse(null);
    }

    @JsonProperty(value="avatarUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<URI> getAvatarUrl_JsonNullable() {
        return this.avatarUrl;
    }

    @JsonProperty(value="avatarUrl")
    public void setAvatarUrl_JsonNullable(JsonNullable<URI> avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public void setAvatarUrl(URI avatarUrl) {
        this.avatarUrl = JsonNullable.of((Object)avatarUrl);
    }

    public Client info(Object info) {
        this.info = JsonNullable.of((Object)info);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A flat curated object with properties that vary for each client platform. All keys are optional and not guaranteed to be available.")
    @JsonIgnore
    public Object getInfo() {
        return this.info.orElse(null);
    }

    @JsonProperty(value="info")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getInfo_JsonNullable() {
        return this.info;
    }

    @JsonProperty(value="info")
    public void setInfo_JsonNullable(JsonNullable<Object> info) {
        this.info = info;
    }

    public void setInfo(Object info) {
        this.info = JsonNullable.of((Object)info);
    }

    public Client raw(Object raw) {
        this.raw = JsonNullable.of((Object)raw);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An object with raw properties that vary for each client platform. All keys are optional and not guaranteed to be available.")
    @JsonIgnore
    public Object getRaw() {
        return this.raw.orElse(null);
    }

    @JsonProperty(value="raw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getRaw_JsonNullable() {
        return this.raw;
    }

    @JsonProperty(value="raw")
    public void setRaw_JsonNullable(JsonNullable<Object> raw) {
        this.raw = raw;
    }

    public void setRaw(Object raw) {
        this.raw = JsonNullable.of((Object)raw);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Client client = (Client)o;
        return Objects.equals(this.id, client.id) && Objects.equals((Object)this.type, (Object)client.type) && Objects.equals((Object)this.status, (Object)client.status) && Objects.equals(this.integrationId, client.integrationId) && Objects.equals(this.externalId, client.externalId) && Objects.equals(this.lastSeen, client.lastSeen) && Objects.equals(this.linkedAt, client.linkedAt) && Objects.equals(this.displayName, client.displayName) && Objects.equals(this.avatarUrl, client.avatarUrl) && Objects.equals(this.info, client.info) && Objects.equals(this.raw, client.raw);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.status, this.integrationId, this.externalId, this.lastSeen, this.linkedAt, this.displayName, this.avatarUrl, this.info, this.raw});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Client {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    lastSeen: ").append(this.toIndentedString(this.lastSeen)).append("\n");
        sb.append("    linkedAt: ").append(this.toIndentedString(this.linkedAt)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    avatarUrl: ").append(this.toIndentedString(this.avatarUrl)).append("\n");
        sb.append("    info: ").append(this.toIndentedString(this.info)).append("\n");
        sb.append("    raw: ").append(this.toIndentedString(this.raw)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("active"),
        BLOCKED("blocked"),
        INACTIVE("inactive"),
        PENDING("pending");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

