/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.MatchCriteria;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"type", "integrationId", "primary", "address", "subject"})
public class MatchCriteriaMailgun
implements MatchCriteria {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "mailgun";
    public static final String JSON_PROPERTY_INTEGRATION_ID = "integrationId";
    private String integrationId;
    public static final String JSON_PROPERTY_PRIMARY = "primary";
    private Boolean primary = true;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private String address;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject = "New message from {appName}";

    public MatchCriteriaMailgun type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The channel type.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MatchCriteriaMailgun integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @ApiModelProperty(example="582dedf230e788746891281a", required=true, value="The ID of the integration to link. Must match the provided type.")
    @JsonProperty(value="integrationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public MatchCriteriaMailgun primary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Flag indicating whether the client will become the primary for the target conversation once linking is complete.")
    @JsonProperty(value="primary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPrimary() {
        return this.primary;
    }

    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    public MatchCriteriaMailgun address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="steveb@channel5.com", required=true, value="The user\u2019s email address.")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public MatchCriteriaMailgun subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="May be specified to set the subject for the outgoing email.")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchCriteriaMailgun matchCriteriaMailgun = (MatchCriteriaMailgun)o;
        return Objects.equals(this.type, matchCriteriaMailgun.type) && Objects.equals(this.integrationId, matchCriteriaMailgun.integrationId) && Objects.equals(this.primary, matchCriteriaMailgun.primary) && Objects.equals(this.address, matchCriteriaMailgun.address) && Objects.equals(this.subject, matchCriteriaMailgun.subject);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.integrationId, this.primary, this.address, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MatchCriteriaMailgun {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    primary: ").append(this.toIndentedString(this.primary)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

