/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Action;
import com.zendesk.sunshine_conversations_client.model.Content;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"type", "mediaUrl", "mediaType", "mediaSize", "altText", "text", "actions", "attachmentId"})
public class ImageMessage
implements Content {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "image";
    public static final String JSON_PROPERTY_MEDIA_URL = "mediaUrl";
    private URI mediaUrl;
    public static final String JSON_PROPERTY_MEDIA_TYPE = "mediaType";
    private String mediaType;
    public static final String JSON_PROPERTY_MEDIA_SIZE = "mediaSize";
    private BigDecimal mediaSize;
    public static final String JSON_PROPERTY_ALT_TEXT = "altText";
    private String altText;
    public static final String JSON_PROPERTY_TEXT = "text";
    private String text;
    public static final String JSON_PROPERTY_ACTIONS = "actions";
    private List<Action> actions = null;
    public static final String JSON_PROPERTY_ATTACHMENT_ID = "attachmentId";
    private String attachmentId;

    public ImageMessage type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The type of message.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ImageMessage mediaUrl(URI mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="The URL for media, such as an image, attached to the message.")
    @JsonProperty(value="mediaUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getMediaUrl() {
        return this.mediaUrl;
    }

    public void setMediaUrl(URI mediaUrl) {
        this.mediaUrl = mediaUrl;
    }

    @Nullable
    @ApiModelProperty(value="The type of media.")
    @JsonProperty(value="mediaType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMediaType() {
        return this.mediaType;
    }

    @Nullable
    @ApiModelProperty(value="The size of the media in bytes.")
    @JsonProperty(value="mediaSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getMediaSize() {
        return this.mediaSize;
    }

    public ImageMessage altText(String altText) {
        this.altText = altText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional description of the image for accessibility purposes. The field will be saved by default with the file name as the value.")
    @JsonProperty(value="altText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAltText() {
        return this.altText;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public ImageMessage text(String text) {
        this.text = text;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The text content of the message. Optional only if actions are provided.")
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ImageMessage actions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    public ImageMessage addActionsItem(Action actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of message actions.")
    @JsonProperty(value="actions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public ImageMessage attachmentId(String attachmentId) {
        this.attachmentId = attachmentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An identifier used by Sunshine Conversations for internal purposes.")
    @JsonProperty(value="attachmentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageMessage imageMessage = (ImageMessage)o;
        return Objects.equals(this.type, imageMessage.type) && Objects.equals(this.mediaUrl, imageMessage.mediaUrl) && Objects.equals(this.mediaType, imageMessage.mediaType) && Objects.equals(this.mediaSize, imageMessage.mediaSize) && Objects.equals(this.altText, imageMessage.altText) && Objects.equals(this.text, imageMessage.text) && Objects.equals(this.actions, imageMessage.actions) && Objects.equals(this.attachmentId, imageMessage.attachmentId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.mediaUrl, this.mediaType, this.mediaSize, this.altText, this.text, this.actions, this.attachmentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageMessage {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    mediaUrl: ").append(this.toIndentedString(this.mediaUrl)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("    mediaSize: ").append(this.toIndentedString(this.mediaSize)).append("\n");
        sb.append("    altText: ").append(this.toIndentedString(this.altText)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    attachmentId: ").append(this.toIndentedString(this.attachmentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

