/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.IntegrationUpdate;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"displayName", "defaultResponderId", "certificate", "password", "production", "autoUpdateBadge", "canUserCreateMoreConversations"})
public class IosUpdate
implements IntegrationUpdate {
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private JsonNullable<String> displayName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEFAULT_RESPONDER_ID = "defaultResponderId";
    private JsonNullable<String> defaultResponderId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CERTIFICATE = "certificate";
    private JsonNullable<String> certificate = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_PRODUCTION = "production";
    private Boolean production;
    public static final String JSON_PROPERTY_AUTO_UPDATE_BADGE = "autoUpdateBadge";
    private Boolean autoUpdateBadge;
    public static final String JSON_PROPERTY_CAN_USER_CREATE_MORE_CONVERSATIONS = "canUserCreateMoreConversations";
    private Boolean canUserCreateMoreConversations;

    public IosUpdate displayName(String displayName) {
        this.displayName = JsonNullable.of((Object)displayName);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My awesome integration", value="A human-friendly name used to identify the integration. `displayName` can be unset by changing it to `null`.")
    @JsonIgnore
    public String getDisplayName() {
        return (String)this.displayName.orElse(null);
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDisplayName_JsonNullable() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName_JsonNullable(JsonNullable<String> displayName) {
        this.displayName = displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = JsonNullable.of((Object)displayName);
    }

    public IosUpdate defaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default responder ID for the integration. This is the ID of the responder that will be used to send messages to the user. For more information, refer to <a href=\"https://docs.smooch.io/guide/switchboard/#per-channel-default-responder\">Per-channel default responder</a> guide. ")
    @JsonIgnore
    public String getDefaultResponderId() {
        return (String)this.defaultResponderId.orElse(null);
    }

    @JsonProperty(value="defaultResponderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDefaultResponderId_JsonNullable() {
        return this.defaultResponderId;
    }

    @JsonProperty(value="defaultResponderId")
    public void setDefaultResponderId_JsonNullable(JsonNullable<String> defaultResponderId) {
        this.defaultResponderId = defaultResponderId;
    }

    public void setDefaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
    }

    public IosUpdate certificate(String certificate) {
        this.certificate = JsonNullable.of((Object)certificate);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_APN_certificate", value="The binary of your APN certificate base64 encoded.")
    @JsonIgnore
    public String getCertificate() {
        return (String)this.certificate.orElse(null);
    }

    @JsonProperty(value="certificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCertificate_JsonNullable() {
        return this.certificate;
    }

    @JsonProperty(value="certificate")
    public void setCertificate_JsonNullable(JsonNullable<String> certificate) {
        this.certificate = certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = JsonNullable.of((Object)certificate);
    }

    public IosUpdate password(String password) {
        this.password = password;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your_APN_password", value="The password for your APN certificate.")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public IosUpdate production(Boolean production) {
        this.production = production;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The APN environment to connect to (Production, if true, or Sandbox). Defaults to value inferred from certificate if not specified.")
    @JsonProperty(value="production")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getProduction() {
        return this.production;
    }

    public void setProduction(Boolean production) {
        this.production = production;
    }

    public IosUpdate autoUpdateBadge(Boolean autoUpdateBadge) {
        this.autoUpdateBadge = autoUpdateBadge;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Use the unread count of the conversation as the application badge.")
    @JsonProperty(value="autoUpdateBadge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutoUpdateBadge() {
        return this.autoUpdateBadge;
    }

    public void setAutoUpdateBadge(Boolean autoUpdateBadge) {
        this.autoUpdateBadge = autoUpdateBadge;
    }

    public IosUpdate canUserCreateMoreConversations(Boolean canUserCreateMoreConversations) {
        this.canUserCreateMoreConversations = canUserCreateMoreConversations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allows users to create more than one conversation on the iOS integration.")
    @JsonProperty(value="canUserCreateMoreConversations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCanUserCreateMoreConversations() {
        return this.canUserCreateMoreConversations;
    }

    public void setCanUserCreateMoreConversations(Boolean canUserCreateMoreConversations) {
        this.canUserCreateMoreConversations = canUserCreateMoreConversations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IosUpdate iosUpdate = (IosUpdate)o;
        return Objects.equals(this.displayName, iosUpdate.displayName) && Objects.equals(this.defaultResponderId, iosUpdate.defaultResponderId) && Objects.equals(this.certificate, iosUpdate.certificate) && Objects.equals(this.password, iosUpdate.password) && Objects.equals(this.production, iosUpdate.production) && Objects.equals(this.autoUpdateBadge, iosUpdate.autoUpdateBadge) && Objects.equals(this.canUserCreateMoreConversations, iosUpdate.canUserCreateMoreConversations);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.defaultResponderId, this.certificate, this.password, this.production, this.autoUpdateBadge, this.canUserCreateMoreConversations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IosUpdate {\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    defaultResponderId: ").append(this.toIndentedString(this.defaultResponderId)).append("\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    production: ").append(this.toIndentedString(this.production)).append("\n");
        sb.append("    autoUpdateBadge: ").append(this.toIndentedString(this.autoUpdateBadge)).append("\n");
        sb.append("    canUserCreateMoreConversations: ").append(this.toIndentedString(this.canUserCreateMoreConversations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

