/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.zendesk.sunshine_conversations_client.model.Android;
import com.zendesk.sunshine_conversations_client.model.Apple;
import com.zendesk.sunshine_conversations_client.model.Custom;
import com.zendesk.sunshine_conversations_client.model.DefaultResponderDefaultResponder;
import com.zendesk.sunshine_conversations_client.model.Instagram;
import com.zendesk.sunshine_conversations_client.model.Integration;
import com.zendesk.sunshine_conversations_client.model.Ios;
import com.zendesk.sunshine_conversations_client.model.Line;
import com.zendesk.sunshine_conversations_client.model.Mailgun;
import com.zendesk.sunshine_conversations_client.model.Messagebird;
import com.zendesk.sunshine_conversations_client.model.Messenger;
import com.zendesk.sunshine_conversations_client.model.Telegram;
import com.zendesk.sunshine_conversations_client.model.Twitter;
import com.zendesk.sunshine_conversations_client.model.Unity;
import com.zendesk.sunshine_conversations_client.model.Viber;
import com.zendesk.sunshine_conversations_client.model.Web;
import com.zendesk.sunshine_conversations_client.model.Whatsapp;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "accountSid", "authToken", "phoneNumberSid", "messagingServiceSid", "defaultResponderId", "defaultResponder"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Android.class, name="android"), @JsonSubTypes.Type(value=Apple.class, name="apple"), @JsonSubTypes.Type(value=Custom.class, name="custom"), @JsonSubTypes.Type(value=Instagram.class, name="instagram"), @JsonSubTypes.Type(value=Ios.class, name="ios"), @JsonSubTypes.Type(value=Line.class, name="line"), @JsonSubTypes.Type(value=Mailgun.class, name="mailgun"), @JsonSubTypes.Type(value=Messagebird.class, name="messagebird"), @JsonSubTypes.Type(value=Messenger.class, name="messenger"), @JsonSubTypes.Type(value=Telegram.class, name="telegram"), @JsonSubTypes.Type(value=Twilio.class, name="twilio"), @JsonSubTypes.Type(value=Twitter.class, name="twitter"), @JsonSubTypes.Type(value=Unity.class, name="unity"), @JsonSubTypes.Type(value=Viber.class, name="viber"), @JsonSubTypes.Type(value=Web.class, name="web"), @JsonSubTypes.Type(value=Whatsapp.class, name="whatsapp")})
public class Twilio
extends Integration {
    public static final String JSON_PROPERTY_TYPE = "type";
    protected String type = "twilio";
    public static final String JSON_PROPERTY_ACCOUNT_SID = "accountSid";
    private String accountSid;
    public static final String JSON_PROPERTY_AUTH_TOKEN = "authToken";
    private String authToken;
    public static final String JSON_PROPERTY_PHONE_NUMBER_SID = "phoneNumberSid";
    private String phoneNumberSid;
    public static final String JSON_PROPERTY_MESSAGING_SERVICE_SID = "messagingServiceSid";
    private String messagingServiceSid;
    public static final String JSON_PROPERTY_DEFAULT_RESPONDER_ID = "defaultResponderId";
    private JsonNullable<String> defaultResponderId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEFAULT_RESPONDER = "defaultResponder";
    private DefaultResponderDefaultResponder defaultResponder;

    @Override
    public Twilio type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="To configure a Twilio integration, acquire the required information from the user and call the Create Integration endpoint. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public Twilio accountSid(String accountSid) {
        this.accountSid = accountSid;
        return this;
    }

    @ApiModelProperty(example="ACa1b4c65ee0722712fab89867cb14eac7", required=true, value="Twilio Account SID.")
    @JsonProperty(value="accountSid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountSid() {
        return this.accountSid;
    }

    public void setAccountSid(String accountSid) {
        this.accountSid = accountSid;
    }

    public Twilio authToken(String authToken) {
        this.authToken = authToken;
        return this;
    }

    @ApiModelProperty(example="160c024303f53049e1e060fd67ca6aefc", required=true, value="Twilio Auth Token.")
    @JsonProperty(value="authToken")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public Twilio phoneNumberSid(String phoneNumberSid) {
        this.phoneNumberSid = phoneNumberSid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="PN0674df0ecee0c9819bca0ff0bc0a159e", value="SID for specific phone number. One of `messagingServiceSid` or `phoneNumberSid` must be provided when creating a Twilio integration.")
    @JsonProperty(value="phoneNumberSid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhoneNumberSid() {
        return this.phoneNumberSid;
    }

    public void setPhoneNumberSid(String phoneNumberSid) {
        this.phoneNumberSid = phoneNumberSid;
    }

    public Twilio messagingServiceSid(String messagingServiceSid) {
        this.messagingServiceSid = messagingServiceSid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SID for specific messaging service. One of `messagingServiceSid` or `phoneNumberSid` must be provided when creating a Twilio integration.")
    @JsonProperty(value="messagingServiceSid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public void setMessagingServiceSid(String messagingServiceSid) {
        this.messagingServiceSid = messagingServiceSid;
    }

    public Twilio defaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default responder ID for the integration. This is the ID of the responder that will be used to send messages to the user. For more information, refer to <a href=\"https://docs.smooch.io/guide/switchboard/#per-channel-default-responder\">Per-channel default responder</a> guide. ")
    @JsonIgnore
    public String getDefaultResponderId() {
        return (String)this.defaultResponderId.orElse(null);
    }

    @JsonProperty(value="defaultResponderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDefaultResponderId_JsonNullable() {
        return this.defaultResponderId;
    }

    @JsonProperty(value="defaultResponderId")
    public void setDefaultResponderId_JsonNullable(JsonNullable<String> defaultResponderId) {
        this.defaultResponderId = defaultResponderId;
    }

    public void setDefaultResponderId(String defaultResponderId) {
        this.defaultResponderId = JsonNullable.of((Object)defaultResponderId);
    }

    public Twilio defaultResponder(DefaultResponderDefaultResponder defaultResponder) {
        this.defaultResponder = defaultResponder;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="defaultResponder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DefaultResponderDefaultResponder getDefaultResponder() {
        return this.defaultResponder;
    }

    public void setDefaultResponder(DefaultResponderDefaultResponder defaultResponder) {
        this.defaultResponder = defaultResponder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Twilio twilio = (Twilio)o;
        return Objects.equals(this.type, twilio.type) && Objects.equals(this.accountSid, twilio.accountSid) && Objects.equals(this.authToken, twilio.authToken) && Objects.equals(this.phoneNumberSid, twilio.phoneNumberSid) && Objects.equals(this.messagingServiceSid, twilio.messagingServiceSid) && Objects.equals(this.defaultResponderId, twilio.defaultResponderId) && Objects.equals(this.defaultResponder, twilio.defaultResponder) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.accountSid, this.authToken, this.phoneNumberSid, this.messagingServiceSid, this.defaultResponderId, this.defaultResponder, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Twilio {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    accountSid: ").append(this.toIndentedString(this.accountSid)).append("\n");
        sb.append("    authToken: ").append(this.toIndentedString(this.authToken)).append("\n");
        sb.append("    phoneNumberSid: ").append(this.toIndentedString(this.phoneNumberSid)).append("\n");
        sb.append("    messagingServiceSid: ").append(this.toIndentedString(this.messagingServiceSid)).append("\n");
        sb.append("    defaultResponderId: ").append(this.toIndentedString(this.defaultResponderId)).append("\n");
        sb.append("    defaultResponder: ").append(this.toIndentedString(this.defaultResponder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

