/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@ApiModel(description="A nested object representing the destination of the message.")
@JsonPropertyOrder(value={"type", "integrationId"})
public class ConversationMessageDeliveryPayloadDestination {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_INTEGRATION_ID = "integrationId";
    private String integrationId;

    public ConversationMessageDeliveryPayloadDestination type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An identifier for the channel to which a message was sent to. May include one of \"web\", \"ios\", \"android\", \"messenger\", \"viber\", \"telegram\", \"wechat\", \"line\", \"twilio\", \"api\", \"notification\", or any other channel.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ConversationMessageDeliveryPayloadDestination integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier indicating which integration the message was sent to.")
    @JsonProperty(value="integrationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationMessageDeliveryPayloadDestination conversationMessageDeliveryPayloadDestination = (ConversationMessageDeliveryPayloadDestination)o;
        return Objects.equals(this.type, conversationMessageDeliveryPayloadDestination.type) && Objects.equals(this.integrationId, conversationMessageDeliveryPayloadDestination.integrationId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.integrationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationMessageDeliveryPayloadDestination {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

