/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"userId", "subscribeSDKClient", "userExternalId"})
public class ParticipantSubSchema {
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;
    public static final String JSON_PROPERTY_SUBSCRIBE_S_D_K_CLIENT = "subscribeSDKClient";
    private Boolean subscribeSDKClient;
    public static final String JSON_PROPERTY_USER_EXTERNAL_ID = "userExternalId";
    private String userExternalId;

    public ParticipantSubSchema userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="42589ad070d43be9b00ff7e5", value="The id of the user that will be participating in the conversation. It will return `404` if the user can\u2019t be found. One of `userId` or `userExternalId` is required, but not both.")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ParticipantSubSchema subscribeSDKClient(Boolean subscribeSDKClient) {
        this.subscribeSDKClient = subscribeSDKClient;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="When passed as true, the SDK client of the concerned participant will be subscribed to the conversation. The user will start receiving push notifications for this conversation right away, without having to view the conversation on the SDK beforehand. An SDK client will be created for users that don\u2019t already have one. This field is required if the conversation is of type `sdkGroup`.")
    @JsonProperty(value="subscribeSDKClient")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSubscribeSDKClient() {
        return this.subscribeSDKClient;
    }

    public void setSubscribeSDKClient(Boolean subscribeSDKClient) {
        this.subscribeSDKClient = subscribeSDKClient;
    }

    public ParticipantSubSchema userExternalId(String userExternalId) {
        this.userExternalId = userExternalId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-own-user-id", value="The `externalId` of the user that will be participating in the conversation. It will return `404` if the user can\u2019t be found. One of `userId` or `userExternalId` is required, but not both.")
    @JsonProperty(value="userExternalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserExternalId() {
        return this.userExternalId;
    }

    public void setUserExternalId(String userExternalId) {
        this.userExternalId = userExternalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParticipantSubSchema participantSubSchema = (ParticipantSubSchema)o;
        return Objects.equals(this.userId, participantSubSchema.userId) && Objects.equals(this.subscribeSDKClient, participantSubSchema.subscribeSDKClient) && Objects.equals(this.userExternalId, participantSubSchema.userExternalId);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.subscribeSDKClient, this.userExternalId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ParticipantSubSchema {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    subscribeSDKClient: ").append(this.toIndentedString(this.subscribeSDKClient)).append("\n");
        sb.append("    userExternalId: ").append(this.toIndentedString(this.userExternalId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

