/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.api;

import com.zendesk.sunshine_conversations_client.ApiClient;
import com.zendesk.sunshine_conversations_client.ApiException;
import com.zendesk.sunshine_conversations_client.Configuration;
import com.zendesk.sunshine_conversations_client.Pair;
import com.zendesk.sunshine_conversations_client.model.DeviceListResponse;
import com.zendesk.sunshine_conversations_client.model.DeviceResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class DevicesApi {
    private ApiClient apiClient;

    public DevicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DevicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DeviceResponse getDevice(String appId, String userIdOrExternalId, String deviceId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getDevice");
        }
        if (userIdOrExternalId == null) {
            throw new ApiException(400, "Missing the required parameter 'userIdOrExternalId' when calling getDevice");
        }
        if (deviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'deviceId' when calling getDevice");
        }
        String localVarPath = "/v2/apps/{appId}/users/{userIdOrExternalId}/devices/{deviceId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userIdOrExternalId\\}", this.apiClient.escapeString(userIdOrExternalId.toString())).replaceAll("\\{deviceId\\}", this.apiClient.escapeString(deviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<DeviceResponse> localVarReturnType = new GenericType<DeviceResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DeviceListResponse listDevices(String appId, String userIdOrExternalId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listDevices");
        }
        if (userIdOrExternalId == null) {
            throw new ApiException(400, "Missing the required parameter 'userIdOrExternalId' when calling listDevices");
        }
        String localVarPath = "/v2/apps/{appId}/users/{userIdOrExternalId}/devices".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userIdOrExternalId\\}", this.apiClient.escapeString(userIdOrExternalId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<DeviceListResponse> localVarReturnType = new GenericType<DeviceListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DeviceResponse getDevice(String bearerToken, String appId, String userIdOrExternalId, String deviceId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getDevice");
        }
        if (userIdOrExternalId == null) {
            throw new ApiException(400, "Missing the required parameter 'userIdOrExternalId' when calling getDevice");
        }
        if (deviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'deviceId' when calling getDevice");
        }
        String localVarPath = "/v2/apps/{appId}/users/{userIdOrExternalId}/devices/{deviceId}".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userIdOrExternalId\\}", this.apiClient.escapeString(userIdOrExternalId.toString())).replaceAll("\\{deviceId\\}", this.apiClient.escapeString(deviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<DeviceResponse> localVarReturnType = new GenericType<DeviceResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DeviceListResponse listDevices(String bearerToken, String appId, String userIdOrExternalId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listDevices");
        }
        if (userIdOrExternalId == null) {
            throw new ApiException(400, "Missing the required parameter 'userIdOrExternalId' when calling listDevices");
        }
        String localVarPath = "/v2/apps/{appId}/users/{userIdOrExternalId}/devices".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{userIdOrExternalId\\}", this.apiClient.escapeString(userIdOrExternalId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<DeviceListResponse> localVarReturnType = new GenericType<DeviceListResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

