/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.api;

import com.zendesk.sunshine_conversations_client.ApiClient;
import com.zendesk.sunshine_conversations_client.ApiException;
import com.zendesk.sunshine_conversations_client.Configuration;
import com.zendesk.sunshine_conversations_client.Pair;
import com.zendesk.sunshine_conversations_client.model.AcceptControlBody;
import com.zendesk.sunshine_conversations_client.model.OfferControlBody;
import com.zendesk.sunshine_conversations_client.model.PassControlBody;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class SwitchboardActionsApi {
    private ApiClient apiClient;

    public SwitchboardActionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SwitchboardActionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Object acceptControl(AcceptControlBody acceptControlBody, String appId, String conversationId) throws ApiException {
        AcceptControlBody localVarPostBody = acceptControlBody;
        if (acceptControlBody == null) {
            throw new ApiException(400, "Missing the required parameter 'acceptControlBody' when calling acceptControl");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling acceptControl");
        }
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling acceptControl");
        }
        String localVarPath = "/v2/apps/{appId}/conversations/{conversationId}/acceptControl".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{conversationId\\}", this.apiClient.escapeString(conversationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object offerControl(OfferControlBody offerControlBody, String appId, String conversationId) throws ApiException {
        OfferControlBody localVarPostBody = offerControlBody;
        if (offerControlBody == null) {
            throw new ApiException(400, "Missing the required parameter 'offerControlBody' when calling offerControl");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling offerControl");
        }
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling offerControl");
        }
        String localVarPath = "/v2/apps/{appId}/conversations/{conversationId}/offerControl".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{conversationId\\}", this.apiClient.escapeString(conversationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object passControl(PassControlBody passControlBody, String appId, String conversationId) throws ApiException {
        PassControlBody localVarPostBody = passControlBody;
        if (passControlBody == null) {
            throw new ApiException(400, "Missing the required parameter 'passControlBody' when calling passControl");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling passControl");
        }
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling passControl");
        }
        String localVarPath = "/v2/apps/{appId}/conversations/{conversationId}/passControl".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{conversationId\\}", this.apiClient.escapeString(conversationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object releaseControl(String appId, String conversationId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling releaseControl");
        }
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling releaseControl");
        }
        String localVarPath = "/v2/apps/{appId}/conversations/{conversationId}/releaseControl".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{conversationId\\}", this.apiClient.escapeString(conversationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object acceptControl(String bearerToken, AcceptControlBody acceptControlBody, String appId, String conversationId) throws ApiException {
        AcceptControlBody localVarPostBody = acceptControlBody;
        if (acceptControlBody == null) {
            throw new ApiException(400, "Missing the required parameter 'acceptControlBody' when calling acceptControl");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling acceptControl");
        }
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling acceptControl");
        }
        String localVarPath = "/v2/apps/{appId}/conversations/{conversationId}/acceptControl".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{conversationId\\}", this.apiClient.escapeString(conversationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object offerControl(String bearerToken, OfferControlBody offerControlBody, String appId, String conversationId) throws ApiException {
        OfferControlBody localVarPostBody = offerControlBody;
        if (offerControlBody == null) {
            throw new ApiException(400, "Missing the required parameter 'offerControlBody' when calling offerControl");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling offerControl");
        }
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling offerControl");
        }
        String localVarPath = "/v2/apps/{appId}/conversations/{conversationId}/offerControl".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{conversationId\\}", this.apiClient.escapeString(conversationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object passControl(String bearerToken, PassControlBody passControlBody, String appId, String conversationId) throws ApiException {
        PassControlBody localVarPostBody = passControlBody;
        if (passControlBody == null) {
            throw new ApiException(400, "Missing the required parameter 'passControlBody' when calling passControl");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling passControl");
        }
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling passControl");
        }
        String localVarPath = "/v2/apps/{appId}/conversations/{conversationId}/passControl".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{conversationId\\}", this.apiClient.escapeString(conversationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object releaseControl(String bearerToken, String appId, String conversationId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling releaseControl");
        }
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling releaseControl");
        }
        String localVarPath = "/v2/apps/{appId}/conversations/{conversationId}/releaseControl".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{conversationId\\}", this.apiClient.escapeString(conversationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Authorization", "Bearer " + bearerToken);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

