/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "projectId", "clientEmail", "privateKey", "serverKey", "senderId", "canUserCreateMoreConversations", "attachmentsEnabled"})
public class AndroidAllOf {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "android";
    public static final String JSON_PROPERTY_PROJECT_ID = "projectId";
    private JsonNullable<String> projectId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CLIENT_EMAIL = "clientEmail";
    private JsonNullable<String> clientEmail = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PRIVATE_KEY = "privateKey";
    private JsonNullable<String> privateKey = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SERVER_KEY = "serverKey";
    private JsonNullable<String> serverKey = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SENDER_ID = "senderId";
    private JsonNullable<String> senderId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CAN_USER_CREATE_MORE_CONVERSATIONS = "canUserCreateMoreConversations";
    private Boolean canUserCreateMoreConversations;
    public static final String JSON_PROPERTY_ATTACHMENTS_ENABLED = "attachmentsEnabled";
    private Boolean attachmentsEnabled;

    public AndroidAllOf type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="<aside class=\"notice\">Firebase Cloud Messaging has deprecated its legacy APIs for HTTP and XMPP. Legacy credentials <code>serverKey</code> and <code>senderId</code> will stop working as of June 2024 and must be replaced with OAuth 2.0 access token based credentials.</aside>  To configure an android integration, first visit the [Firebase Console](https://console.firebase.google.com/).  Generate a private key from the Service accounts tab in the settings.  Copy the `project_id`, `client_email` and `private_key` from the generated JSON file and call the create integrations endpoint with this data. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AndroidAllOf projectId(String projectId) {
        this.projectId = JsonNullable.of((Object)projectId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="<project-id>", value="Your project ID from your generated private key file.")
    @JsonIgnore
    public String getProjectId() {
        return (String)this.projectId.orElse(null);
    }

    @JsonProperty(value="projectId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getProjectId_JsonNullable() {
        return this.projectId;
    }

    @JsonProperty(value="projectId")
    public void setProjectId_JsonNullable(JsonNullable<String> projectId) {
        this.projectId = projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = JsonNullable.of((Object)projectId);
    }

    public AndroidAllOf clientEmail(String clientEmail) {
        this.clientEmail = JsonNullable.of((Object)clientEmail);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="<client-email>", value="Your client email from your generated private key file.")
    @JsonIgnore
    public String getClientEmail() {
        return (String)this.clientEmail.orElse(null);
    }

    @JsonProperty(value="clientEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getClientEmail_JsonNullable() {
        return this.clientEmail;
    }

    @JsonProperty(value="clientEmail")
    public void setClientEmail_JsonNullable(JsonNullable<String> clientEmail) {
        this.clientEmail = clientEmail;
    }

    public void setClientEmail(String clientEmail) {
        this.clientEmail = JsonNullable.of((Object)clientEmail);
    }

    public AndroidAllOf privateKey(String privateKey) {
        this.privateKey = JsonNullable.of((Object)privateKey);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="<private-key>", value="Your private key from your generated private key file.")
    @JsonIgnore
    public String getPrivateKey() {
        return (String)this.privateKey.orElse(null);
    }

    @JsonProperty(value="privateKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPrivateKey_JsonNullable() {
        return this.privateKey;
    }

    @JsonProperty(value="privateKey")
    public void setPrivateKey_JsonNullable(JsonNullable<String> privateKey) {
        this.privateKey = privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = JsonNullable.of((Object)privateKey);
    }

    public AndroidAllOf serverKey(String serverKey) {
        this.serverKey = JsonNullable.of((Object)serverKey);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="<server-key>", value="Your server key from the fcm console.")
    @JsonIgnore
    public String getServerKey() {
        return (String)this.serverKey.orElse(null);
    }

    @JsonProperty(value="serverKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getServerKey_JsonNullable() {
        return this.serverKey;
    }

    @JsonProperty(value="serverKey")
    public void setServerKey_JsonNullable(JsonNullable<String> serverKey) {
        this.serverKey = serverKey;
    }

    public void setServerKey(String serverKey) {
        this.serverKey = JsonNullable.of((Object)serverKey);
    }

    public AndroidAllOf senderId(String senderId) {
        this.senderId = JsonNullable.of((Object)senderId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="<sender-id>", value="Your sender id from the fcm console.")
    @JsonIgnore
    public String getSenderId() {
        return (String)this.senderId.orElse(null);
    }

    @JsonProperty(value="senderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSenderId_JsonNullable() {
        return this.senderId;
    }

    @JsonProperty(value="senderId")
    public void setSenderId_JsonNullable(JsonNullable<String> senderId) {
        this.senderId = senderId;
    }

    public void setSenderId(String senderId) {
        this.senderId = JsonNullable.of((Object)senderId);
    }

    public AndroidAllOf canUserCreateMoreConversations(Boolean canUserCreateMoreConversations) {
        this.canUserCreateMoreConversations = canUserCreateMoreConversations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allows users to create more than one conversation on the android integration.")
    @JsonProperty(value="canUserCreateMoreConversations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCanUserCreateMoreConversations() {
        return this.canUserCreateMoreConversations;
    }

    public void setCanUserCreateMoreConversations(Boolean canUserCreateMoreConversations) {
        this.canUserCreateMoreConversations = canUserCreateMoreConversations;
    }

    @Nullable
    @ApiModelProperty(value="Allows users to send attachments. By default, the setting is set to true. This setting can only be configured in Zendesk Admin Center. ")
    @JsonProperty(value="attachmentsEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAttachmentsEnabled() {
        return this.attachmentsEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidAllOf androidAllOf = (AndroidAllOf)o;
        return Objects.equals(this.type, androidAllOf.type) && Objects.equals(this.projectId, androidAllOf.projectId) && Objects.equals(this.clientEmail, androidAllOf.clientEmail) && Objects.equals(this.privateKey, androidAllOf.privateKey) && Objects.equals(this.serverKey, androidAllOf.serverKey) && Objects.equals(this.senderId, androidAllOf.senderId) && Objects.equals(this.canUserCreateMoreConversations, androidAllOf.canUserCreateMoreConversations) && Objects.equals(this.attachmentsEnabled, androidAllOf.attachmentsEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.projectId, this.clientEmail, this.privateKey, this.serverKey, this.senderId, this.canUserCreateMoreConversations, this.attachmentsEnabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AndroidAllOf {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    clientEmail: ").append(this.toIndentedString(this.clientEmail)).append("\n");
        sb.append("    privateKey: ").append(this.toIndentedString(this.privateKey)).append("\n");
        sb.append("    serverKey: ").append(this.toIndentedString(this.serverKey)).append("\n");
        sb.append("    senderId: ").append(this.toIndentedString(this.senderId)).append("\n");
        sb.append("    canUserCreateMoreConversations: ").append(this.toIndentedString(this.canUserCreateMoreConversations)).append("\n");
        sb.append("    attachmentsEnabled: ").append(this.toIndentedString(this.attachmentsEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

