/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.ConversationType;
import com.zendesk.sunshine_conversations_client.model.SwitchboardIntegrationWebhook;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"id", "type", "metadata", "activeSwitchboardIntegration", "pendingSwitchboardIntegration", "isDefault", "displayName", "description", "iconUrl", "businessLastRead", "lastUpdatedAt", "createdAt"})
public class Conversation {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ConversationType type;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private JsonNullable<Object> metadata = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ACTIVE_SWITCHBOARD_INTEGRATION = "activeSwitchboardIntegration";
    private JsonNullable<SwitchboardIntegrationWebhook> activeSwitchboardIntegration = JsonNullable.of(null);
    public static final String JSON_PROPERTY_PENDING_SWITCHBOARD_INTEGRATION = "pendingSwitchboardIntegration";
    private JsonNullable<SwitchboardIntegrationWebhook> pendingSwitchboardIntegration = JsonNullable.of(null);
    public static final String JSON_PROPERTY_IS_DEFAULT = "isDefault";
    private Boolean isDefault;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName = null;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private JsonNullable<String> description = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ICON_URL = "iconUrl";
    private JsonNullable<URI> iconUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_BUSINESS_LAST_READ = "businessLastRead";
    private JsonNullable<String> businessLastRead = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LAST_UPDATED_AT = "lastUpdatedAt";
    private JsonNullable<String> lastUpdatedAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private String createdAt;

    public Conversation id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="c93bb9c14dde8ffb94564eae", value="The unique ID of the conversation.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Conversation type(ConversationType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConversationType getType() {
        return this.type;
    }

    public void setType(ConversationType type) {
        this.type = type;
    }

    public Conversation metadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"lang\":\"en-ca\"}", value="Flat object containing custom properties. Strings, numbers and booleans  are the only supported format that can be passed to metadata. The metadata is limited to 4KB in size. ")
    @JsonIgnore
    public Object getMetadata() {
        return this.metadata.orElse(null);
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getMetadata_JsonNullable() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata_JsonNullable(JsonNullable<Object> metadata) {
        this.metadata = metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
    }

    public Conversation activeSwitchboardIntegration(SwitchboardIntegrationWebhook activeSwitchboardIntegration) {
        this.activeSwitchboardIntegration = JsonNullable.of((Object)activeSwitchboardIntegration);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The current switchboard integration that is in control of the conversation. This field is omitted if no `activeSwitchboardIntegration` exists for the conversation.")
    @JsonIgnore
    public SwitchboardIntegrationWebhook getActiveSwitchboardIntegration() {
        return (SwitchboardIntegrationWebhook)this.activeSwitchboardIntegration.orElse(null);
    }

    @JsonProperty(value="activeSwitchboardIntegration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<SwitchboardIntegrationWebhook> getActiveSwitchboardIntegration_JsonNullable() {
        return this.activeSwitchboardIntegration;
    }

    @JsonProperty(value="activeSwitchboardIntegration")
    public void setActiveSwitchboardIntegration_JsonNullable(JsonNullable<SwitchboardIntegrationWebhook> activeSwitchboardIntegration) {
        this.activeSwitchboardIntegration = activeSwitchboardIntegration;
    }

    public void setActiveSwitchboardIntegration(SwitchboardIntegrationWebhook activeSwitchboardIntegration) {
        this.activeSwitchboardIntegration = JsonNullable.of((Object)activeSwitchboardIntegration);
    }

    public Conversation pendingSwitchboardIntegration(SwitchboardIntegrationWebhook pendingSwitchboardIntegration) {
        this.pendingSwitchboardIntegration = JsonNullable.of((Object)pendingSwitchboardIntegration);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The switchboard integration that is awaiting control. This field is omitted if no switchboard integration has been previously offered control.")
    @JsonIgnore
    public SwitchboardIntegrationWebhook getPendingSwitchboardIntegration() {
        return (SwitchboardIntegrationWebhook)this.pendingSwitchboardIntegration.orElse(null);
    }

    @JsonProperty(value="pendingSwitchboardIntegration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<SwitchboardIntegrationWebhook> getPendingSwitchboardIntegration_JsonNullable() {
        return this.pendingSwitchboardIntegration;
    }

    @JsonProperty(value="pendingSwitchboardIntegration")
    public void setPendingSwitchboardIntegration_JsonNullable(JsonNullable<SwitchboardIntegrationWebhook> pendingSwitchboardIntegration) {
        this.pendingSwitchboardIntegration = pendingSwitchboardIntegration;
    }

    public void setPendingSwitchboardIntegration(SwitchboardIntegrationWebhook pendingSwitchboardIntegration) {
        this.pendingSwitchboardIntegration = JsonNullable.of((Object)pendingSwitchboardIntegration);
    }

    public Conversation isDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether the conversation is the default conversation for the user. Will be true for the first personal conversation created for the user, and false in all other cases. ")
    @JsonProperty(value="isDefault")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public Conversation displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My conversation", value="A friendly name for the conversation, may be displayed to the business or the user. ")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Conversation description(String description) {
        this.description = JsonNullable.of((Object)description);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Conversation between Rogers and Carl.", value="A short text describing the conversation.")
    @JsonIgnore
    public String getDescription() {
        return (String)this.description.orElse(null);
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDescription_JsonNullable() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription_JsonNullable(JsonNullable<String> description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = JsonNullable.of((Object)description);
    }

    public Conversation iconUrl(URI iconUrl) {
        this.iconUrl = JsonNullable.of((Object)iconUrl);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://www.gravatar.com/image.jpg", value="A custom conversation icon url. The image must be in either JPG, PNG, or GIF format")
    @JsonIgnore
    public URI getIconUrl() {
        return (URI)this.iconUrl.orElse(null);
    }

    @JsonProperty(value="iconUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<URI> getIconUrl_JsonNullable() {
        return this.iconUrl;
    }

    @JsonProperty(value="iconUrl")
    public void setIconUrl_JsonNullable(JsonNullable<URI> iconUrl) {
        this.iconUrl = iconUrl;
    }

    public void setIconUrl(URI iconUrl) {
        this.iconUrl = JsonNullable.of((Object)iconUrl);
    }

    public Conversation businessLastRead(String businessLastRead) {
        this.businessLastRead = JsonNullable.of((Object)businessLastRead);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-06-23T14:33:47.492Z", value="A datetime string with the format YYYY-MM-DDThh:mm:ss.SSSZ representing the moment the conversation was last marked as read with role business. ")
    @JsonIgnore
    public String getBusinessLastRead() {
        return (String)this.businessLastRead.orElse(null);
    }

    @JsonProperty(value="businessLastRead")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getBusinessLastRead_JsonNullable() {
        return this.businessLastRead;
    }

    @JsonProperty(value="businessLastRead")
    public void setBusinessLastRead_JsonNullable(JsonNullable<String> businessLastRead) {
        this.businessLastRead = businessLastRead;
    }

    public void setBusinessLastRead(String businessLastRead) {
        this.businessLastRead = JsonNullable.of((Object)businessLastRead);
    }

    public Conversation lastUpdatedAt(String lastUpdatedAt) {
        this.lastUpdatedAt = JsonNullable.of((Object)lastUpdatedAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-06-26T14:33:47.120Z", value="A datetime string with the format YYYY-MM-DDThh:mm:ss.SSSZ representing the moment the last message was received in the conversation, or the creation time if no messages have been received yet. ")
    @JsonIgnore
    public String getLastUpdatedAt() {
        return (String)this.lastUpdatedAt.orElse(null);
    }

    @JsonProperty(value="lastUpdatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getLastUpdatedAt_JsonNullable() {
        return this.lastUpdatedAt;
    }

    @JsonProperty(value="lastUpdatedAt")
    public void setLastUpdatedAt_JsonNullable(JsonNullable<String> lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public void setLastUpdatedAt(String lastUpdatedAt) {
        this.lastUpdatedAt = JsonNullable.of((Object)lastUpdatedAt);
    }

    public Conversation createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-06-20T11:26:07.001Z", value="A datetime string with the format YYYY-MM-DDThh:mm:ss.SSSZ representing the creation time of the conversation. ")
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conversation conversation = (Conversation)o;
        return Objects.equals(this.id, conversation.id) && Objects.equals((Object)this.type, (Object)conversation.type) && Objects.equals(this.metadata, conversation.metadata) && Objects.equals(this.activeSwitchboardIntegration, conversation.activeSwitchboardIntegration) && Objects.equals(this.pendingSwitchboardIntegration, conversation.pendingSwitchboardIntegration) && Objects.equals(this.isDefault, conversation.isDefault) && Objects.equals(this.displayName, conversation.displayName) && Objects.equals(this.description, conversation.description) && Objects.equals(this.iconUrl, conversation.iconUrl) && Objects.equals(this.businessLastRead, conversation.businessLastRead) && Objects.equals(this.lastUpdatedAt, conversation.lastUpdatedAt) && Objects.equals(this.createdAt, conversation.createdAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.metadata, this.activeSwitchboardIntegration, this.pendingSwitchboardIntegration, this.isDefault, this.displayName, this.description, this.iconUrl, this.businessLastRead, this.lastUpdatedAt, this.createdAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Conversation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    activeSwitchboardIntegration: ").append(this.toIndentedString(this.activeSwitchboardIntegration)).append("\n");
        sb.append("    pendingSwitchboardIntegration: ").append(this.toIndentedString(this.pendingSwitchboardIntegration)).append("\n");
        sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    iconUrl: ").append(this.toIndentedString(this.iconUrl)).append("\n");
        sb.append("    businessLastRead: ").append(this.toIndentedString(this.businessLastRead)).append("\n");
        sb.append("    lastUpdatedAt: ").append(this.toIndentedString(this.lastUpdatedAt)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

