/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.MatchCriteria;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"type", "integrationId", "primary", "phoneNumber"})
public class MatchCriteriaTwilio
implements MatchCriteria {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "twilio";
    public static final String JSON_PROPERTY_INTEGRATION_ID = "integrationId";
    private String integrationId;
    public static final String JSON_PROPERTY_PRIMARY = "primary";
    private Boolean primary = true;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private String phoneNumber;

    public MatchCriteriaTwilio type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="The channel type.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MatchCriteriaTwilio integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @ApiModelProperty(example="582dedf230e788746891281a", required=true, value="The ID of the integration to link. Must match the provided type.")
    @JsonProperty(value="integrationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public MatchCriteriaTwilio primary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Flag indicating whether the client will become the primary for the target conversation once linking is complete.")
    @JsonProperty(value="primary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPrimary() {
        return this.primary;
    }

    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    public MatchCriteriaTwilio phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(example="+15550001234", required=true, value="The user\u2019s phone number. It must contain the + prefix and the country code. Examples of valid phone numbers: +1 212-555-2368, +12125552368, +1 212 555 2368. Examples of invalid phone numbers: 212 555 2368, 1 212 555 2368. ")
    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchCriteriaTwilio matchCriteriaTwilio = (MatchCriteriaTwilio)o;
        return Objects.equals(this.type, matchCriteriaTwilio.type) && Objects.equals(this.integrationId, matchCriteriaTwilio.integrationId) && Objects.equals(this.primary, matchCriteriaTwilio.primary) && Objects.equals(this.phoneNumber, matchCriteriaTwilio.phoneNumber);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.integrationId, this.primary, this.phoneNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MatchCriteriaTwilio {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    primary: ").append(this.toIndentedString(this.primary)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

