/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Author;
import com.zendesk.sunshine_conversations_client.model.Content;
import com.zendesk.sunshine_conversations_client.model.Destination;
import com.zendesk.sunshine_conversations_client.model.MessageOverride;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"author", "content", "destination", "metadata", "override", "schema"})
public class MessagePost {
    public static final String JSON_PROPERTY_AUTHOR = "author";
    private Author author = null;
    public static final String JSON_PROPERTY_CONTENT = "content";
    private Content content = null;
    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private Destination destination = null;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private JsonNullable<Object> metadata = JsonNullable.undefined();
    public static final String JSON_PROPERTY_OVERRIDE = "override";
    private MessageOverride override = null;
    public static final String JSON_PROPERTY_SCHEMA = "schema";
    private String schema;

    public MessagePost author(Author author) {
        this.author = author;
        return this;
    }

    @ApiModelProperty(required=true, value="The author of the message.")
    @JsonProperty(value="author")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Author getAuthor() {
        return this.author;
    }

    public void setAuthor(Author author) {
        this.author = author;
    }

    public MessagePost content(Content content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(required=true, value="The content of the message.")
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public MessagePost destination(Destination destination) {
        this.destination = destination;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public MessagePost metadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"lang\":\"en-ca\"}", value="Flat object containing custom properties. Strings, numbers and booleans  are the only supported format that can be passed to metadata. The metadata is limited to 4KB in size. ")
    @JsonIgnore
    public Object getMetadata() {
        return this.metadata.orElse(null);
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getMetadata_JsonNullable() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata_JsonNullable(JsonNullable<Object> metadata) {
        this.metadata = metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = JsonNullable.of((Object)metadata);
    }

    public MessagePost override(MessageOverride override) {
        this.override = override;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="override")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MessageOverride getOverride() {
        return this.override;
    }

    public void setOverride(MessageOverride override) {
        this.override = override;
    }

    public MessagePost schema(String schema) {
        this.schema = schema;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="whatsapp", value="When `schema` is set to `\"whatsapp\"`, the `content` key is expected to conform to the [native WhatsApp schema](https://developers.facebook.com/docs/whatsapp/api/messages/message-templates) for sending message templates. For more details, consult the documentation for [sending message templates on WhatsApp](https://docs.smooch.io/guide/whatsapp/#sending-message-templates). ")
    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagePost messagePost = (MessagePost)o;
        return Objects.equals(this.author, messagePost.author) && Objects.equals(this.content, messagePost.content) && Objects.equals(this.destination, messagePost.destination) && Objects.equals(this.metadata, messagePost.metadata) && Objects.equals(this.override, messagePost.override) && Objects.equals(this.schema, messagePost.schema);
    }

    public int hashCode() {
        return Objects.hash(this.author, this.content, this.destination, this.metadata, this.override, this.schema);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessagePost {\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    override: ").append(this.toIndentedString(this.override)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

