/*
 * Sunshine Conversations API
 *
 * The version of the OpenAPI document: 14.3.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.zendesk.sunshine_conversations_client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.zendesk.sunshine_conversations_client.model.Client;
import com.zendesk.sunshine_conversations_client.model.ConversationTruncated;
import com.zendesk.sunshine_conversations_client.model.SourceWebhook;
import com.zendesk.sunshine_conversations_client.model.UserTruncated;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * The payload of the event. The contents of this object depend on the type of event.
 */
@ApiModel(description = "The payload of the event. The contents of this object depend on the type of event.")
@JsonPropertyOrder({
  ClientRemoveEventAllOfPayload.JSON_PROPERTY_CONVERSATION,
  ClientRemoveEventAllOfPayload.JSON_PROPERTY_USER,
  ClientRemoveEventAllOfPayload.JSON_PROPERTY_CLIENT,
  ClientRemoveEventAllOfPayload.JSON_PROPERTY_REASON,
  ClientRemoveEventAllOfPayload.JSON_PROPERTY_ERROR,
  ClientRemoveEventAllOfPayload.JSON_PROPERTY_SOURCE
})

public class ClientRemoveEventAllOfPayload {
  public static final String JSON_PROPERTY_CONVERSATION = "conversation";
  private JsonNullable<ConversationTruncated> conversation = JsonNullable.<ConversationTruncated>of(null);

  public static final String JSON_PROPERTY_USER = "user";
  private UserTruncated user = null;

  public static final String JSON_PROPERTY_CLIENT = "client";
  private Client client = null;

  /**
   * The reason for which the client was removed. * &#x60;api&#x60; - The client was removed using the API. * &#x60;linkCancelled&#x60; - The user cancelled a channel link. * &#x60;linkFailed&#x60; - The client was removed after a channel link attempt failed. * &#x60;sdk&#x60; - The client was removed using the SDK. * &#x60;theft&#x60; - The client was transferred to another user due to a channel link. 
   */
  public enum ReasonEnum {
    API("api"),
    
    LINKCANCELLED("linkCancelled"),
    
    LINKFAILED("linkFailed"),
    
    SDK("sdk"),
    
    THEFT("theft");

    private String value;

    ReasonEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ReasonEnum fromValue(String value) {
      for (ReasonEnum b : ReasonEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REASON = "reason";
  private ReasonEnum reason;

  public static final String JSON_PROPERTY_ERROR = "error";
  private JsonNullable<Object> error = JsonNullable.<Object>undefined();

  public static final String JSON_PROPERTY_SOURCE = "source";
  private SourceWebhook source = null;


  public ClientRemoveEventAllOfPayload conversation(ConversationTruncated conversation) {
    this.conversation = JsonNullable.<ConversationTruncated>of(conversation);
    
    return this;
  }

   /**
   * The conversation associated with the removal of the client. This field is only present when the reason is &#x60;theft&#x60;, &#x60;linkCancelled&#x60; or &#x60;linkFailed&#x60;. Note that for the &#x60;theft&#x60; reason, the conversation will not be present if it has been deleted. 
   * @return conversation
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The conversation associated with the removal of the client. This field is only present when the reason is `theft`, `linkCancelled` or `linkFailed`. Note that for the `theft` reason, the conversation will not be present if it has been deleted. ")
  @JsonIgnore

  public ConversationTruncated getConversation() {
        return conversation.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CONVERSATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<ConversationTruncated> getConversation_JsonNullable() {
    return conversation;
  }
  
  @JsonProperty(JSON_PROPERTY_CONVERSATION)
  public void setConversation_JsonNullable(JsonNullable<ConversationTruncated> conversation) {
    this.conversation = conversation;
  }

  public void setConversation(ConversationTruncated conversation) {
    this.conversation = JsonNullable.<ConversationTruncated>of(conversation);
  }


  public ClientRemoveEventAllOfPayload user(UserTruncated user) {
    
    this.user = user;
    return this;
  }

   /**
   * The user associated with the client.
   * @return user
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The user associated with the client.")
  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UserTruncated getUser() {
    return user;
  }


  public void setUser(UserTruncated user) {
    this.user = user;
  }


  public ClientRemoveEventAllOfPayload client(Client client) {
    
    this.client = client;
    return this;
  }

   /**
   * The removed client.
   * @return client
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The removed client.")
  @JsonProperty(JSON_PROPERTY_CLIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Client getClient() {
    return client;
  }


  public void setClient(Client client) {
    this.client = client;
  }


  public ClientRemoveEventAllOfPayload reason(ReasonEnum reason) {
    
    this.reason = reason;
    return this;
  }

   /**
   * The reason for which the client was removed. * &#x60;api&#x60; - The client was removed using the API. * &#x60;linkCancelled&#x60; - The user cancelled a channel link. * &#x60;linkFailed&#x60; - The client was removed after a channel link attempt failed. * &#x60;sdk&#x60; - The client was removed using the SDK. * &#x60;theft&#x60; - The client was transferred to another user due to a channel link. 
   * @return reason
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The reason for which the client was removed. * `api` - The client was removed using the API. * `linkCancelled` - The user cancelled a channel link. * `linkFailed` - The client was removed after a channel link attempt failed. * `sdk` - The client was removed using the SDK. * `theft` - The client was transferred to another user due to a channel link. ")
  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ReasonEnum getReason() {
    return reason;
  }


  public void setReason(ReasonEnum reason) {
    this.reason = reason;
  }


  public ClientRemoveEventAllOfPayload error(Object error) {
    this.error = JsonNullable.<Object>of(error);
    
    return this;
  }

   /**
   * Object containing details of what went wrong. This field will only be present when the reason is &#x60;linkCancelled&#x60; or &#x60;linkFailed&#x60;.
   * @return error
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "Object containing details of what went wrong. This field will only be present when the reason is `linkCancelled` or `linkFailed`.")
  @JsonIgnore

  public Object getError() {
        return error.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Object> getError_JsonNullable() {
    return error;
  }
  
  @JsonProperty(JSON_PROPERTY_ERROR)
  public void setError_JsonNullable(JsonNullable<Object> error) {
    this.error = error;
  }

  public void setError(Object error) {
    this.error = JsonNullable.<Object>of(error);
  }


  public ClientRemoveEventAllOfPayload source(SourceWebhook source) {
    
    this.source = source;
    return this;
  }

   /**
   * The source where this event originated from. This could be the API or an SDK device.
   * @return source
  **/
  @jakarta.annotation.Nullable
  @ApiModelProperty(value = "The source where this event originated from. This could be the API or an SDK device.")
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SourceWebhook getSource() {
    return source;
  }


  public void setSource(SourceWebhook source) {
    this.source = source;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ClientRemoveEventAllOfPayload clientRemoveEventAllOfPayload = (ClientRemoveEventAllOfPayload) o;
    return Objects.equals(this.conversation, clientRemoveEventAllOfPayload.conversation) &&
        Objects.equals(this.user, clientRemoveEventAllOfPayload.user) &&
        Objects.equals(this.client, clientRemoveEventAllOfPayload.client) &&
        Objects.equals(this.reason, clientRemoveEventAllOfPayload.reason) &&
        Objects.equals(this.error, clientRemoveEventAllOfPayload.error) &&
        Objects.equals(this.source, clientRemoveEventAllOfPayload.source);
  }

  @Override
  public int hashCode() {
    return Objects.hash(conversation, user, client, reason, error, source);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ClientRemoveEventAllOfPayload {\n");
    sb.append("    conversation: ").append(toIndentedString(conversation)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    client: ").append(toIndentedString(client)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

