/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.zendesk.sunshine_conversations_client.model.Client;
import com.zendesk.sunshine_conversations_client.model.ConversationTruncated;
import com.zendesk.sunshine_conversations_client.model.UserTruncated;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

@ApiModel(description="The payload of the event. The contents of this object depend on the type of event.")
@JsonPropertyOrder(value={"conversation", "user", "client", "reason"})
public class ClientUpdateEventAllOfPayload {
    public static final String JSON_PROPERTY_CONVERSATION = "conversation";
    private ConversationTruncated conversation = null;
    public static final String JSON_PROPERTY_USER = "user";
    private UserTruncated user = null;
    public static final String JSON_PROPERTY_CLIENT = "client";
    private Client client = null;
    public static final String JSON_PROPERTY_REASON = "reason";
    private ReasonEnum reason;

    public ClientUpdateEventAllOfPayload conversation(ConversationTruncated conversation) {
        this.conversation = conversation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The conversation which triggered a change in the client.")
    @JsonProperty(value="conversation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConversationTruncated getConversation() {
        return this.conversation;
    }

    public void setConversation(ConversationTruncated conversation) {
        this.conversation = conversation;
    }

    public ClientUpdateEventAllOfPayload user(UserTruncated user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user associated with the client.")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserTruncated getUser() {
        return this.user;
    }

    public void setUser(UserTruncated user) {
        this.user = user;
    }

    public ClientUpdateEventAllOfPayload client(Client client) {
        this.client = client;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The updated client.")
    @JsonProperty(value="client")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public ClientUpdateEventAllOfPayload reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason for which the client was updated. * `confirmed` - The client is now active and ready to use. * `blocked` - The user has unsubscribed from the conversation. * `unblocked` - A previously unsubscribed user resubscribed to the conversation. * `matched` - The channel found a user that matches the information provided. ")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReasonEnum getReason() {
        return this.reason;
    }

    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientUpdateEventAllOfPayload clientUpdateEventAllOfPayload = (ClientUpdateEventAllOfPayload)o;
        return Objects.equals(this.conversation, clientUpdateEventAllOfPayload.conversation) && Objects.equals(this.user, clientUpdateEventAllOfPayload.user) && Objects.equals(this.client, clientUpdateEventAllOfPayload.client) && Objects.equals((Object)this.reason, (Object)clientUpdateEventAllOfPayload.reason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conversation, this.user, this.client, this.reason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClientUpdateEventAllOfPayload {\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    client: ").append(this.toIndentedString(this.client)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ReasonEnum {
        CONFIRMED("confirmed"),
        BLOCKED("blocked"),
        UNBLOCKED("unblocked"),
        MATCHED("matched");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

