/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.sunshine_conversations_client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zendesk.sunshine_conversations_client.model.Conversation;
import com.zendesk.sunshine_conversations_client.model.Links;
import com.zendesk.sunshine_conversations_client.model.Meta;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"conversations", "meta", "links"})
public class ConversationListResponse {
    public static final String JSON_PROPERTY_CONVERSATIONS = "conversations";
    private List<Conversation> conversations = null;
    public static final String JSON_PROPERTY_META = "meta";
    private Meta meta;
    public static final String JSON_PROPERTY_LINKS = "links";
    private Links links;

    public ConversationListResponse conversations(List<Conversation> conversations) {
        this.conversations = conversations;
        return this;
    }

    public ConversationListResponse addConversationsItem(Conversation conversationsItem) {
        if (this.conversations == null) {
            this.conversations = new ArrayList<Conversation>();
        }
        this.conversations.add(conversationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of returned conversations.")
    @JsonProperty(value="conversations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Conversation> getConversations() {
        return this.conversations;
    }

    public void setConversations(List<Conversation> conversations) {
        this.conversations = conversations;
    }

    public ConversationListResponse meta(Meta meta) {
        this.meta = meta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Meta getMeta() {
        return this.meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public ConversationListResponse links(Links links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Links getLinks() {
        return this.links;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationListResponse conversationListResponse = (ConversationListResponse)o;
        return Objects.equals(this.conversations, conversationListResponse.conversations) && Objects.equals(this.meta, conversationListResponse.meta) && Objects.equals(this.links, conversationListResponse.links);
    }

    public int hashCode() {
        return Objects.hash(this.conversations, this.meta, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationListResponse {\n");
        sb.append("    conversations: ").append(this.toIndentedString(this.conversations)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

